***********************************************************************
* File: Passwords.asm
* Description: Code security configuration and setup for DCSM zone #2
* Devices: TMS320F2805x
* Author: David M. Alter, Texas Instruments Inc.
* History:
*   12/21/12 - original (D. Alter)
* Notes:
*  1) See the F2805x Technical Reference Manual, Literature #SPRUHE5 for
*     information on the security table entries.
*  2) It is recommended that ALL security table entries be left as 0xFFFF
*     during code development.  Passwords of 0xFFFF are dummy passwords
*     and do not lock the code security module (dummy reads of the four
*     32-bit password in the zone select block specified by the
*     Z2-LINKPOINTER will unlock security zone 2).  When code development
*     is complete, the user can program the needed values to configure
*     the DCSM as desired.
*  3) Section dcsm_otp_z2 must be linked to address 0x3D7800.
*  4) Section dcsm_zsel_z2 must be linked to the offset from 0x3D7800
*     specified by the Z2-LINKPOINTER value.  See the device user's guide,
*     literature #SPRUHE5 for values (it is NOT value = offset).
***********************************************************************

      .sect "dcsm_otp_z2"

	  .long 0xFFFFFFFF     ;Z2-LINKPOINTER
	  .long 0xFFFFFFFF     ;Z2-OTPSECLOCK
	  .long 0xFFFFFFFF     ;Z2-BOOTMODE

      .sect "dcsm_zsel_z2"

      .long	0xFFFFFFFF		;Z2-EXEONLYRAM
      .long	0xFFFFFFFF		;Z2-EXEONLYSECT
      .long	0xFFFFFFFF		;Z2-GRABRAM
      .long	0xFFFFFFFF		;Z2-GRABSECT

      .long	0xFFFFFFFF		;Z2-CSMPSWD0 (LSW of 128-bit password)
      .long	0xFFFFFFFF		;Z2-CSMPSWD1
      .long	0xFFFFFFFF		;Z2-CSMPSWD2
      .long	0xFFFFFFFF		;Z2-CSMPSWD3 (MSW of 128-bit password)

***********************************************************************

	.end
; end of file Passwords_zone2.asm
