/**********************************************************************
* File: Main_BIOS.c
* Devices: TMS320F2833x
* Author: David M. Alter, Texas Instruments Inc.
* History:
*   12/18/07 - original (D. Alter)
**********************************************************************/
#include "F28335_example.h"				// Main include file

//--- Global Variables
Uint16 AdcBuf[ADC_BUF_LEN];				// ADC data buffer allocation
Uint32 PwmDuty;							// Measured PWM duty cycle
Uint32 PwmPeriod;						// Measured PWM period

/**********************************************************************
* Function: main()
*
* Description: Main function for F2833x example.
**********************************************************************/
void main(void)
{
//--- CPU Initialization
	InitSysCtrl();						// Initialize the CPU
	InitPieCtrl();						// Initialize and enable the PIE
	InitWatchdog();						// Initialize the Watchdog Timer
	InitGpio();							// Initialize the shared GPIO pins
	InitXintf();						// Initialize the external memory interface

#ifdef EXAMPLE_FLASH					// EXAMPLE_FLASH, if defined, is in CCS project options

//--- Copy all Flash sections that need to run from RAM (use memcpy() from RTS library)

// Section secureRamFuncs contains user defined code that runs from CSM secured RAM
	memcpy(&secureRamFuncs_runstart, &secureRamFuncs_loadstart, (Uint32)&secureRamFuncs_loadsize);

//--- Initialize the Flash and OTP
	InitFlash();						// Initialize the Flash

#endif

//--- Peripheral Initialization
	InitAdc();							// Initialize the ADC
	InitEPwm();							// Initialize the PWM
	InitECap();							// Initialize the Capture units

//--- Enable interrupts
	SetDBGIER(IER | 0x6000);							// Enable everything in IER, plus TINT2 and DLOGINT
	*(volatile unsigned int *)0x00000C14 |= 0x0C00;		// Set TIMER2 FREE=SOFT=1

    // DSP/BIOS will enable global interrupts (INTM and DBGM)

} // end of main()



/**********************************************************************
* Function: UserInit()
*
* Description: This is the user initialization file to be specified in
* the DSP/BIOS configuration file, System - Global Settings.
**********************************************************************/
void UserInit(void)
{
#ifdef EXAMPLE_FLASH					// EXAMPLE_FLASH, if defined, is in CCS project options

// Section .trcdata is generated by DSP/BIOS.
// It must be copied from its load to its run address BEFORE main().
	memcpy(&trcdata_runstart, &trcdata_loadstart, (Uint32)&trcdata_loadsize);

#endif

} // end of UserInit()



/**********************************************************************
* Function: LedBlink()
*
* Description: Blinks LED on eZdspF28335 board and F28335 Control Card.
**********************************************************************/
void LedBlink(void)
{
static Uint16 LedPrdCount=0;					// Used for LOG_printf example

	GpioDataRegs.GPBTOGGLE.bit.GPIO32 = 1;		// Toggle the pin
	GpioDataRegs.GPBTOGGLE.bit.GPIO34 = 1;		// Toggle the pin

//--- Show an example of using LOG_printf() to write to a log buffer
	LOG_printf(&trace, "LedPrdCount = %u", LedPrdCount++);

} // end of LedBlink()



/**********************************************************************
* Function: AdcSwi()
*
* Description: ADC interrupt SWI
**********************************************************************/
void AdcSwi(void)
{
static Uint16 *AdcBufPtr = AdcBuf;				// Pointer to buffer

//--- Manage the ADC registers
	AdcRegs.ADCTRL2.bit.RST_SEQ1 = 1;			// Reset SEQ1 to CONV00 state
	AdcRegs.ADCST.bit.INT_SEQ1_CLR = 1;			// Clear ADC SEQ1 interrupt flag

//--- Read the ADC result
	*AdcBufPtr++ = AdcRegs.ADCRESULT0 >> 4;		// Read the result

//--- Brute-force the circular buffer
	if( AdcBufPtr == (AdcBuf + ADC_BUF_LEN) )
		AdcBufPtr = AdcBuf;						// Rewind the pointer to beginning

} // end of AdcSwi()


//--- end of file -----------------------------------------------------
