/**********************************************************************
* File: F28035_nonBIOS_flash.cmd -- Linker command file for non-DSP/BIOS
* code with DSP in jump-to-flash boot mode.
*
* History:
*   01/20/11 - Deleted unneeded Boot ROM memory definitions.
               Added CLA message RAM definitions. (D. Alter)
*   07/02/09 - original (D. Alter)
**********************************************************************/

MEMORY
{
PAGE 0:    /* Program Memory */
   BEGIN_M0           : origin = 0x000000, length = 0x000002     /* Part of M0SARAM.  Used for "Boot to M0" bootloader mode. */
   L0SARAM            : origin = 0x008000, length = 0x000800     /* L0 SARAM, CSM secure */
   L3DPSARAM          : origin = 0x009000, length = 0x001000     /* L3 DPSARAM, CSM secure, CLA Prog RAM */
   OTP            (R) : origin = 0x3D7800, length = 0x000400     /* OTP */
   FLASH_ABCDEFGH (R) : origin = 0x3E8000, length = 0x00FF80     /* FLASH, All sectors combined */
   CSM_RSVD       (R) : origin = 0x3F7F80, length = 0x000076     /* Part of FLASH Sector A.  Reserved when CSM is in use. */
   BEGIN_FLASH    (R) : origin = 0x3F7FF6, length = 0x000002     /* Part of FLASH Sector A.  Used for "Jump to flash" bootloader mode. */
   PASSWORDS      (R) : origin = 0x3F7FF8, length = 0x000008     /* Part of FLASH Sector A.  CSM password locations. */
   IQTABLES       (R) : origin = 0x3FE000, length = 0x000B50     /* Part of Boot ROM */
   IQTABLES2      (R) : origin = 0x3FEB50, length = 0x00008C     /* Part of Boot ROM */
   IQTABLES3      (R) : origin = 0x3FEBDC, length = 0x0000AA     /* Part of Boot ROM */
   RESET          (R) : origin = 0x3FFFC0, length = 0x000002     /* part of Boot ROM */

 PAGE 1 :   /* Data Memory */
   M0SARAM            : origin = 0x000002, length = 0x0003FE     /* M0 SARAM */
   M1SARAM            : origin = 0x000400, length = 0x000400     /* M1 SARAM */
   CLA1_TO_CPU_MSGRAM : origin = 0x001480, length = 0x000080     /* CLA1 to CPU message RAM */
   CPU_TO_CLA1_MSGRAM : origin = 0x001500, length = 0x000080     /* CPU to CLA1 message RAM */
   L1DPSARAM          : origin = 0x008800, length = 0x000400     /* L1 DPSARAM, CSM secure, CLA Data RAM 0 */
   L2DPSARAM          : origin = 0x008C00, length = 0x000400     /* L2 DPSARAM, CSM secure, CLA Data RAM 1 */
}

 
SECTIONS
{
/*** Compiler Required Sections ***/

  /* Program memory (PAGE 0) sections */
   .text              : > FLASH_ABCDEFGH,        PAGE = 0
   .cinit             : > FLASH_ABCDEFGH,        PAGE = 0
   .const             : > FLASH_ABCDEFGH,        PAGE = 0
   .econst            : > FLASH_ABCDEFGH,        PAGE = 0      
   .pinit             : > FLASH_ABCDEFGH,        PAGE = 0
   .reset             : > RESET,                 PAGE = 0, TYPE = DSECT  /* We are not using the .reset section */
   .switch            : > FLASH_ABCDEFGH,        PAGE = 0

  /* Data Memory (PAGE 1) sections */
   .bss               : > M0SARAM,               PAGE = 1
   .ebss              : > M0SARAM,               PAGE = 1
   .cio               : > M0SARAM,               PAGE = 1
   .stack             : > M1SARAM,               PAGE = 1
   .sysmem            : > M1SARAM,               PAGE = 1
   .esysmem           : > M1SARAM,               PAGE = 1

/*** User Defined Sections ***/
   codestart         : > BEGIN_FLASH,           PAGE = 0                /* Used by file CodeStartBranch.asm */
   csm_rsvd          : > CSM_RSVD,              PAGE = 0                /* Used by file Passwords.asm */
   passwords         : > PASSWORDS,             PAGE = 0                /* Used by file Passwords.asm */
   secureRamFuncs    :   LOAD = FLASH_ABCDEFGH, PAGE = 0                /* Used by file Flash.c */
                         RUN = L0SARAM,         PAGE = 0                /* Load to flash, run from CSM secure RAM */
                         LOAD_START(_secureRamFuncs_loadstart),
                         LOAD_SIZE(_secureRamFuncs_loadsize),
                         RUN_START(_secureRamFuncs_runstart)
}

/******************* end of file ************************/
