/*
 *  Copyright 2003 by Texas Instruments Incorporated.
 *  All rights reserved. Property of Texas Instruments Incorporated.
 *  Restricted rights to use, duplicate or disclose this code are
 *  granted through contract.
 *  
 */
/* "@(#) DDK 1.10.00.23 07-02-03 (ddk-b12)" */
#include <vport.h>
#include <vportcap.h>
#include <saa7115.h> 
#include <csl_edma.h>
#include "evmdm642_vcapparams.h"

#define LINE_SZ   240
#define NUM_LINES 160

VPORTCAP_Params EVMDM642_vCapParamsChan = {
    VPORT_MODE_BT656_8BIT, /* cmode:3  */
    VPORT_FLDOP_FRAME,     /* fldOp:3  */    

    VPORT_SCALING_DISABLE, /* scale:1  */    
    VPORT_RESMPL_DISABLE,  /* resmpl:1 */
    VPORTCAP_BPK_10BIT_ZERO_EXTENDED, /*bpk10Bit:2   */

    VPORTCAP_HRST_SAV,     /*hCtRst:1  */
    VPORTCAP_VRST_EAV_V0,  /*vCtRst:1  */
    VPORTCAP_FLDD_DISABLE, /*fldDect:1 */
    VPORTCAP_EXC_DISABLE,  /*extCtl:1  */   
    VPORTCAP_FINV_ENABLE,  /* fldInv:1 */
    
    0,                     /*fldXStrt1 */
    1,                     /*fldYStrt1 */  
    0,                     /*fldXStrt2 */  
    1, //15,               /*fldYStrt2 */
    
    LINE_SZ-1,             /*fldXStop1 */
    NUM_LINES, //+14,      /*fldYStop1 */
    
    LINE_SZ-1,             /*fldXStop2 */
    NUM_LINES, //+14,      /*fldYStop2 */
    
    (LINE_SZ>>3),          /*thrld     */
    3,                     /*numFrmBufs*/
    128,                     /*alignment */
    VPORT_FLDS_MERGED,     /*mergeFlds */
    NULL,                  /*segId     */            
    EDMA_OPT_PRI_HIGH,     /*edmaPri   */
    8                      /* irqId    */
};




VPORT_PortParams EVMDM642_vCapParamsPort = {
    FALSE,                      /*  enableDualChan;                */ 
    VPORT_POLARITY_ACTIVE_HIGH, /* vport control pin 1 polarity    */
    VPORT_POLARITY_ACTIVE_HIGH, /* vport control pin 2 polarity    */
    VPORT_POLARITY_ACTIVE_HIGH, /* vport control pin 3 polarity    */
    &SAA7115_Fxns,
    INV,
};    

SAA7115_ConfParams EVMDM642_vCapParamsSAA7115 = {
  SAA7115_MODE_NTSC720,
  SAA7115_MODE_USER,
  SAA7115_AFMT_COMPOSITE,
  TRUE,
  TRUE,   
  INV,
  LINE_SZ,
  NUM_LINES*2,
  TRUE,
};    



