/*
 *  Copyright 2003 by Texas Instruments Incorporated.
 *  All rights reserved. Property of Texas Instruments Incorporated.
 *  Restricted rights to use, duplicate or disclose this code are
 *  granted through contract.
 *  
 */
/* "@(#) DDK 1.11.00.00 11-04-03 (ddk-b13)" */
#include <std.h>
#include <tsk.h>  
#include <sem.h>   
#include <gio.h>

#include <csl_dat.h>
#include <csl_cache.h>

#include <fvid.h>
#include <edc.h>
#include <vport.h>
#include <vportcap.h>
#include <vportdis.h>
//#include <saa7105.h>
#include <saa7115.h>    

#include <evmdm642.h>

#include "colorbarRGB.h"
#include "evmdm642_vcapparams.h"
#include "evmdm642_vdisparams.h"

/* heap IDs defined in the BIOS configuration file */
extern Int EXTERNALHEAP;
#ifdef _LOOPBACK
static const  short coeffs[5] = {0x2543, 0x3313, -0x0C8A, -0x1A04, 0x408D};
#endif

/*
 * ======== main ========
 */
main()
{
    CSL_init();
    CACHE_clean(CACHE_L2ALL, 0, 0);
    CACHE_setL2Mode(CACHE_128KCACHE);       
    CACHE_enableCaching(CACHE_EMIFA_CE00);
    CACHE_enableCaching(CACHE_EMIFA_CE01);    
    DAT_open(DAT_CHAANY, DAT_PRI_LOW, DAT_OPEN_2D);

}

/*
 * ======== tskVideoLoopback ========
 * video loopback function.
 */
void tskVideoLoopback()
{
    Int status;
    FVID_Handle disChan; 
    Int frames = 0;
    FVID_Frame *disFrameBuf;
    Int numLinesDis = EVMDM642_vDisParamsChan.imgVSizeFld1;
    Int numLinesCap = EVMDM642_vCapParamsChan.fldYStop1 -
       EVMDM642_vCapParamsChan.fldYStrt1+1;

    
    Int numLines = (numLinesDis > numLinesCap) ? numLinesCap : numLinesDis;

#ifdef _LOOPBACK
    Int i;
    FVID_Handle capChan; 
    Int numPixels = EVMDM642_vCapParamsChan.fldXStop1 - 
       EVMDM642_vCapParamsChan.fldXStrt1+1;
    FVID_Frame *capFrameBuf;
    Int capLinePitch = EVMDM642_vCapParamsChan.fldXStop1 - 
       EVMDM642_vCapParamsChan.fldXStrt1+1;
    Int disLinePitch = EVMDM642_vDisParamsChan.imgHSizeFld1;


#ifdef _PIP
    VPORTCAP_Params EVMDM642_vCapParamsChan2 = EVMDM642_vCapParamsChan;
    FVID_Handle capChan2; 
    FVID_Frame *capFrameBuf2;
    Int yPitch = capLinePitch >> 1;
    Int cPitch = ((capLinePitch >> 2) + 7) & (~ 7);
    Int xOffset = disLinePitch - yPitch;
    Int yOffset = numLinesDis - numLines;
#endif
#endif                

 
    numLines *= 2; /* both fields */
    /******************************************************/
    /* allocate both capture and display frame buffers    */
    /* in external heap memory                            */
    /******************************************************/
        EVMDM642_vCapParamsChan.segId = EXTERNALHEAP;
        EVMDM642_vDisParamsChan.segId = EXTERNALHEAP;
        
        /* No Encoder needed in RAW output to LCD controller */ 
//        EVMDM642_vDisParamsSAA7105.hI2C = EVMDM642_I2C_hI2C;
        EVMDM642_vCapParamsSAA7115.hI2C = EVMDM642_I2C_hI2C;

    /******************************************************/
    /* initialization of capture driver                   */
    /******************************************************/
#ifdef _LOOPBACK
    capChan = FVID_create("/VP0CAPTURE/A/0", 
            IOM_INPUT, &status, (Ptr)&EVMDM642_vCapParamsChan, NULL);

#ifdef _PIP
    EVMDM642_vCapParamsChan2.scale = VPORT_SCALING_ENABLE;
        EVMDM642_vCapParamsChan2.fldOp = VPORT_FLDOP_FLD1;        
        EVMDM642_vCapParamsChan2.thrld >>=1;
    capChan2 = FVID_create("/VP1CAPTURE/A/1", 
            IOM_INPUT, &status, (Ptr)&EVMDM642_vCapParamsChan2, NULL);
#endif          

#endif          
    /******************************************************/
    /* initialization of display driver                   */
    /******************************************************/
    disChan = FVID_create("/VP2DISPLAY", IOM_OUTPUT, 
        &status, (Ptr)&EVMDM642_vDisParamsChan, NULL);

    
    /******************************************************/
    /* configure video encoder & decoder                  */
    /******************************************************/
    
    /* No Encoder needed in RAW output to LCD controller */
//    FVID_control(disChan, VPORT_CMD_EDC_BASE + EDC_CONFIG, 
//        (Ptr)&EVMDM642_vDisParamsSAA7105);
#ifdef _LOOPBACK
    FVID_control(capChan, VPORT_CMD_EDC_BASE + EDC_CONFIG, 
        (Ptr)&EVMDM642_vCapParamsSAA7115);
#ifdef _PIP
    EVMDM642_vCapParamsSAA7115.aFmt = SAA7115_AFMT_COMPOSITE;
    FVID_control(capChan2, VPORT_CMD_EDC_BASE+EDC_CONFIG, 
        (Ptr)&EVMDM642_vCapParamsSAA7115);
#endif
#endif

    /******************************************************/
    /* start capture & display operation                  */    
    /******************************************************/
    FVID_control(disChan, VPORT_CMD_START, NULL);
#ifdef _LOOPBACK
    FVID_control(capChan, VPORT_CMD_START, NULL);
#ifdef _PIP
    FVID_control(capChan2, VPORT_CMD_START, NULL);
#endif    
#endif    
    
    /********************************************************/
    /* request a frame buffer from display & capture driver */
    /********************************************************/
    FVID_alloc(disChan, &disFrameBuf);
#ifdef _LOOPBACK
    FVID_alloc(capChan, &capFrameBuf);
#ifdef _PIP
    FVID_alloc(capChan2, &capFrameBuf2);
#endif      
#endif
    frames ++;


    while(1){/* loop forever */
#ifdef _LOOPBACK
        /* copy data from capture buffer to display buffer */
        /***************************************************/
        for(i = 0; i < numLines; i++) {
            yc2rgb16(coeffs, capFrameBuf->frame.iFrm.y1 + i * (capLinePitch),
                capFrameBuf->frame.iFrm.cb1 + (capLinePitch >> 1) * i, 
                capFrameBuf->frame.iFrm.cr1 + (capLinePitch >> 1) * i, 
                disFrameBuf->frame.rpFrm.buf + (disLinePitch << 1) * i, 
                numPixels);
        }
        FVID_exchange(capChan, &capFrameBuf);
#ifdef _PIP  
        for(i = 0; i < (numLines >> 1); i++) {
            yc2rgb16(coeffs, capFrameBuf2->frame.iFrm.y1 + i * yPitch,
                capFrameBuf2->frame.iFrm.cb1 + cPitch * i, 
                capFrameBuf2->frame.iFrm.cr1 + cPitch * i, 
                disFrameBuf->frame.rpFrm.buf + (disLinePitch << 1) 
                * (yOffset + i) + (xOffset * 2), (numPixels >> 1));
        }
        FVID_exchange(capChan2, &capFrameBuf2);
#endif

#else
        FillFrmBufRGB(&disFrameBuf->frame.rpFrm, EVMDM642_vDisParamsChan.imgHSizeFld1,
            EVMDM642_vDisParamsChan.imgVSizeFld1, frames %(EVMDM642_vDisParamsChan.imgHSizeFld1 >> 3));
#endif
        CACHE_clean(CACHE_L2ALL, 0, 0);
        FVID_exchange(disChan, &disFrameBuf); 
        
        frames ++;              
   }
}



