/*
 *  ======== irotate.h ========
 *  IROTATE Interface Header
 */
#ifndef IROTATE_
#define IROTATE_

#include <ti/xdais/ialg.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  ======== IROTATE_Handle ========
 *  This handle is used to reference all ROTATE instance objects
 */
typedef struct IROTATE_Obj *IROTATE_Handle;

/*
 *  ======== IROTATE_Obj ========
 *  This structure must be the first field of all ROTATE instance objects
 */
typedef struct IROTATE_Obj {
    struct IROTATE_Fxns *fxns;    
} IROTATE_Obj;

/*
 *  ======== IROTATE_Params ========
 *  This structure defines the creation parameters for all ROTATE objects
 */
typedef struct IROTATE_Params {
    Int  size;          /* must be first field of all params structures */
    Bool reverseImage;
} IROTATE_Params;

/*
 *  ======== IROTATE_PARAMS ========
 *  Default parameter values for ROTATE instance objects
 */
extern IROTATE_Params IROTATE_PARAMS;

/*
 *  ======== IROTATE_Fxns ========
 *  This structure defines all of the operations on ROTATE objects
 */
typedef struct IROTATE_Fxns {
    IALG_Fxns   ialg;    /* IROTATE extends IALG */
    Void (*apply)(IROTATE_Handle handle, unsigned char y[], 
                  unsigned char cr[], unsigned char cb[], 
                  Int lumaSize, Int chromaSize, Short cosine, Short sine);
} IROTATE_Fxns;

#ifdef __cplusplus
}
#endif /* extern "C" */

#endif  /* IROTATE_ */

/*! Revision History
 *! ================
 *! 18-Oct-2002 tdm   Created
 *! */

