/*!
 *  ======== ROTATE ========
 *  ROTATE codec specification
 *
 *  This file specifies information necessary to integrate with the Codec
 *  Engine.
 *
 *  By inheriting ti.sdo.apps.extensions.rotate.IROTATE, ROTATE declares that 
 *  its interface conforms to the (adapted) IROTATE interface.  This allows the 
 *  corresponding stubs and skeletons to be used for transparent execution of 
 *  DSP code by the GPP.
 *
 *  In addition to declaring the type of the ROTATE algorithm, we
 *  declare the external symbol required by xDAIS that identifies the
 *  algorithms implementation functions.
 */
metaonly module ROTATE inherits ti.sdo.apps.extensions.rotate.IROTATE
{
    /*!
     *  ======== ialgFxns ========
     *  name of this algorithm's xDAIS alg fxn table
     */
    override readonly config String ialgFxns = "ROTATE_TI_IROTATE_ADAPT";
}
