/*
 *  ======== irotate_adapt.h ========
 *  Adapted ROTATE Interface Header
 */
#ifndef IROTATE_ADAPT_
#define IROTATE_ADAPT_

#include <ti/xdais/dm/iimgdec.h>
#include <ti/sdo/apps/codecs/rotate/irotate.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 *  @brief      Defines the creation time parameters for
 *              all adapted IROTATE instance objects.
 *
 *  @remarks    This structure may be extended by individual codec
 *              implementation allowing customization with vendor
 *   
 */
typedef struct IROTATE_ADAPT_Params {
    IIMGDEC_Params iimgdecParams;  /**< Must be first field */
    IROTATE_Params irotateParams;  /**< Parameters for the algorithm */
    XDAS_Int32 maxImageSize;    /**< Max size of image buffer to be processed */
} IROTATE_ADAPT_Params;

/**
 *  @brief      Defines the input arguments for all adapted IROTATE instance
 *              process function.
 *
 *  @remarks    This structure may be extended by individual codec
 *              implementation allowing customization with vendor
 *              specific parameters.
 */
typedef struct IROTATE_ADAPT_InArgs {
    IIMGDEC_InArgs  iimgdecInArgs;   /**< Must be first field */
    XDAS_Int16 cosine;  /**< cosine of angle by which to rotate chroma planes */
    XDAS_Int16 sine;    /**< sine of angle by which to rotate chroma planes */  
} IROTATE_ADAPT_InArgs;

/**
 *  @brief      Defines the run time output arguments for
 *              all adapted IROTATE instance objects.
 *
 *  @remarks    This structure may be extended by individual codec
 *              implementations allowing customization with vendor
 *              specific parameters.
 */
typedef struct IROTATE_ADAPT_OutArgs {
    IIMGDEC_OutArgs iimgdecOutArgs;  /**< Must be first field */
} IROTATE_ADAPT_OutArgs;


#ifdef __cplusplus
}
#endif /* extern "C" */

#endif  /* IROTATE_ADAPT_ */
