/*!
 *  ======== ROTATE ========
 *  ROTATE codec specification
 *
 *  This file specifies information necessary to integrate with the Codec
 *  Engine.
 *
 *  By inheriting ti.sdo.ce.image.IIMGDEC, ROTATE declares that its interface
 *  "is close to" an image decoder algorithm.  This allows the codec engine to
 *  automatically supply simple stubs and skeletons for transparent execution
 *  of DSP code by the GPP.
 *
 *  In addition to declaring the type of the ROTATE algorithm, we
 *  declare the external symbol required by xDAIS that identifies the
 *  algorithms implementation functions. In our case, this is the function
 *  table exported by the adapted algorithm.
 */
metaonly module ROTATE inherits ti.sdo.ce.image.IIMGDEC
{
    /*!
     *  ======== idma3Fxns ========
     *  name of the idma3 fxn table
     *  Uncomment the following line if using DMA in adapter 
     */
    /* override readonly config String idma3Fxns = "ROTATE_TI_IIMGDEC_IDMA3"; */

    /*!
     *  ======== ialgFxns ========
     *  name of the adapted algorithm's xDAIS alg fxn table
     */
    override readonly config String ialgFxns = "ROTATE_TI_IIMGDEC";

}
