/*
 *  ======== irotate_adapt.h ========
 *  Adapted ROTATE Interface Header
 */
#ifndef IROTATE_ADAPT_
#define IROTATE_ADAPT_

#include <ti/xdais/ialg.h>
#include <ti/xdais/xdas.h>
#include <ti/sdo/apps/codecs/rotate/irotate.h>

#ifdef __cplusplus
extern "C" {
#endif

#define IROTATE_ADAPT_EFAIL -1
#define IROTATE_ADAPT_EOK 0

/*
 *  ======== IROTATE_ADAPT_Params ========
 *  Defines the creation time parameters for all adapted IROTATE 
 *  instance objects.
 */
typedef struct IROTATE_ADAPT_Params {
    IROTATE_Params irotateParams;  /* Must be first field */
    XDAS_Int32 maxImageSize;    /* Max size of image buffer to be processed */
} IROTATE_ADAPT_Params;
	
/*
 *  ======== IROTATE_ADAPT_InArgs ========
 *  This structure defines an input argument struct for adapted ROTATE objects
 */
typedef struct IROTATE_ADAPT_InArgs {
    XDAS_Int32 bufSize;
    XDAS_Int16 cosine;
    XDAS_Int16 sine;
} IROTATE_ADAPT_InArgs;

/*
 *  ======== IROTATE_ADAPT_Fxns ========
 *  This structure defines all of the operations on adapted ROTATE objects
 */
typedef struct IROTATE_ADAPT_Fxns {
    IALG_Fxns   ialg;    /* IROTATE extends IALG */
    XDAS_Int32 (*process)(IROTATE_Handle handle, XDAS_Int8 inBuf[], 
        XDAS_Int8 outBuf[], IROTATE_ADAPT_InArgs * inArgs);
} IROTATE_ADAPT_Fxns;

#ifdef __cplusplus
}
#endif /* extern "C" */

#endif  /* IROTATE_ADAPT_ */
