/*
 *  ======== dm642init.c ========
 *
 *
 */

//--------------------------------------------------------------------------
// IP Stack Client Demo
//--------------------------------------------------------------------------
// dm642init.c
//
// Private initialization functions for EVMDM642
//
// Author: Michael A. Denio
// Copyright 2003 by Texas Instruments Inc.
//--------------------------------------------------------------------------
#include <stdio.h>
#include <netmain.h>
#include <csl.h>
#include <csl_cache.h>
#include <evmdm642.h>
#include <evmdm642_led.h>
#include <evmdm642_eeprom.h>

// New CSL Functions in csl_mdio.c
CSLAPI uint MDIO_phyRegWrite( uint phyIdx, uint phyReg, Uint16 data );
CSLAPI uint MDIO_phyRegRead( uint, uint, UINT16 * );

// This string array corresponds to link state as define in csl_mdio.h
static char *LinkStr[] = { "No Link",
                           "10Mb/s Half Duplex",
                           "10Mb/s Full Duplex",
                           "100Mb/s Half Duplex",
                           "100Mb/s Full Duplex" };

static UINT8 bMacAddr[8];

//
// Main Thread
//
// We changed our CDB file to point call this private init
// function. Here we initialize our board and read in our
// MAC address.
//
void dm642_init()
{
    // Init cache mode manually
    CSL_init();

    CACHE_clean(CACHE_L2ALL, 0, 0);
    /*
     *  The DSP/BIOS cache initialization is done late. Hence;
     *  we initialize it earlier whcih is going to be overwritten
     *  later. This setting must be less than the size configured
     *  through DSP/BIOS.
     */
    CACHE_setL2Mode(CACHE_32KCACHE);
    CACHE_enableCaching(CACHE_EMIFA_CE00);
    CACHE_enableCaching(CACHE_EMIFA_CE01);

    // Init the EVM
    EVMDM642_init();
    EVMDM642_LED_init();

    // Read in EMAC MAC Address
    EVMDM642_EEPROM_read(0x00007F00, (Uint32)bMacAddr, 8);
}

//
// DM642EMAC_getConfig()
//
// This is a callback from the Ethernet driver. This function
// is used by the driver to get its 6 byte MAC address, and
// to determine which DSP interrupt the EMAC should be mapped to.
//
void DM642EMAC_getConfig( UINT8 *pMacAddr, uint *pIntVector )
{
    printf("Using MAC Address: %02x-%02x-%02x-%02x-%02x-%02x\n",
            bMacAddr[0], bMacAddr[1], bMacAddr[2],
            bMacAddr[3], bMacAddr[4], bMacAddr[5]);

    // We fill in the two pointers here. We'll use int 5 for EMAC
    mmCopy( pMacAddr, bMacAddr, 6 );
    *pIntVector = 5;
}

//
// DM642EMAC_linkStatus()
//
// This is a callback from the Ethernet driver. This function
// is called whenever there is a change in link state. The
// current PHY and current link state are passed as parameters.
//
void DM642EMAC_linkStatus( uint phy, uint linkStatus )
{
    printf("Link Status: %s on PHY %d\n",LinkStr[linkStatus],phy);

    // Since we know we're using the Intel PHY, we'll
    // go ahead and program the LEDs to make sense.
    MDIO_phyRegWrite( phy, 0x14, 0xd5d0 );
}

