//############################################################################
//
// FILE:   F2833x_EEPROM_Example.c
//
// TITLE:  F2833x Emulating EEPROM Example 
//
// ASSUMPTIONS:
//
//    This program uses the DSP2833x header files and Flash API already  
// 	  included in the download. Project was tested with F28335 eZdsp. 
//	  No additional hardware is required. 
//
// DESCRIPTION:
//	 
//	 This project provides an example of how to emulate EEPROM functionality  
//	 using the internal flash memory of the device. Example will write data to 
//	 memory and then read data that was written. Read_Buffer can be monitored  
//	 in watch window to verify data.
// 
//############################################################################		
// Authors: Tim Love / Pradeep Shinde
// Release Date: Sep 2009
//############################################################################


#include "F2833x_EEPROM.h"
#include "DSP2833x_Device.h"     // DSP281x Headerfile Include File
#include "DSP2833x_Examples.h"   // DSP281x Examples Include File
#include <stdio.h>

extern Uint32 Flash_CPUScaleFactor;

void main(void)
{
	Uint16 i, data;

// 	Step 1. Initialize System Control:
// 	PLL, WatchDog, enable Peripheral Clocks
// 	This example function is found in the DSP280x_SysCtrl.c file.
   	InitSysCtrl();
 
// 	Step 2. Initalize GPIO: 
// 	This example function is found in the DSP280x_Gpio.c file and
// 	illustrates how to set the GPIO to it's default state.
// 	InitGpio();  // Skipped for this example
 
// 	For this example use the following configuration:
//  Gpio_select();	  

// 	Step 3. Clear all interrupts and initialize PIE vector table:
// 	Disable CPU interrupts 
   	DINT;

// 	Initialize PIE control registers to their default state.
// 	The default state is all PIE interrupts disabled and flags
// 	are cleared.  
// 	This function is found in the DSP280x_PieCtrl.c file.
   	InitPieCtrl();

// 	Disable CPU interrupts and clear all CPU interrupt flags:
   	IER = 0x0000;
   	IFR = 0x0000;

// 	Initialize the PIE vector table with pointers to the shell Interrupt 
// 	Service Routines (ISR).  
// 	This will populate the entire table, even if the interrupt
// 	is not used in this example.  This is useful for debug purposes.
// 	The shell ISR routines are found in DSP280x_DefaultIsr.c.
// 	This function is found in DSP280x_PieVect.c.
   	InitPieVectTable();

   	MemCopy(&RamfuncsLoadStart, &RamfuncsLoadEnd, &RamfuncsRunStart);
	InitFlash();

	
// 	Step 4. Initialize all the Device Peripherals:
// 	This function is found in DSP280x_InitPeripherals.c
// 	InitPeripherals(); // Not required for this example
	
// 	Step 5. User specific code:

	// Copy the Flash API functions to SARAM
    MemCopy(&Flash28_API_LoadStart, &Flash28_API_LoadEnd, &Flash28_API_RunStart);

	// Set Factor and Callback for Flash API
	Flash_CPUScaleFactor = SCALE_FACTOR;
	Flash_CallbackPtr = NULL;

// If programming single byte, find correct pointer and set test data	
	#ifdef SINGLE_BYTE	
	EEPROM_GetSinglePointer(1);
	data = 1;
	
	// If programming multiple bytes, set example data in Write_Buffer
	#else
	for(i=0;i<64;i++)
		Write_Buffer[i] = 0xABCD;
	#endif

	while(1)
	{
		for(i=0;i<65;i++)
		{

			// If programming single byte, call single byte function
			#ifdef SINGLE_BYTE
			EEPROM_ProgramSingleByte(data);

			// If programming multiple bytes, call write function 
			#else
			EEPROM_Write();
			EEPROM_Read();
			#endif
		}
		
  	asm(" ESTOP0"); 
	}  
}	



