//############################################################################
//
// FILE:   F2833x_EEPROM.h
//
// TITLE:  Function Prototypes, Global Variables, Pointer Initialization
//		   and, Bank/Page Status Definitions  
//
//############################################################################
// Authors: Tim Love / Pradeep Shinde
// Release Date: Sep 2009 
//############################################################################


// Include Flash API Header Files
#ifdef F2823x
#include "Flash2823x_API_Config.h" 		
#include "Flash2823x_API_Library.h"		
#else
#include "Flash2833x_API_Config.h" 		
#include "Flash2833x_API_Library.h"		
#endif

// Project specific defines
//#define SINGLE_BYTE 1
#define MULTI_BYTE  1

// Pointer Initialization
#ifdef F28332
#define RESET_BANK_POINTER Bank_Pointer = (Uint16 *)0x330000	// Sector D
#define RESET_PAGE_POINTER Page_Pointer = (Uint16 *)0x330001
#define END_OF_SECTOR 0x333FFF;
#endif

#ifdef F28334
#define RESET_BANK_POINTER Bank_Pointer = (Uint16 *)0x320000	// Sector H
#define RESET_PAGE_POINTER Page_Pointer = (Uint16 *)0x320001
#define END_OF_SECTOR 0x323FFF;
#endif

#ifdef F28335
#define RESET_BANK_POINTER Bank_Pointer = (Uint16 *)0x300000	// Sector H 
#define RESET_PAGE_POINTER Page_Pointer = (Uint16 *)0x300001
#define END_OF_SECTOR 0x307FFF;
#endif

// Bank/Page Status Definitions
#define EMPTY_BANK 	 0xFFFF
#define CURRENT_BANK 0xA00A
#define USED_BANK 	 0x0000
#define BLANK_PAGE 	 0xFFFF
#define CURRENT_PAGE 0x00FF
#define USED_PAGE 	 0x0000	

// Function Prototypes
extern void EEPROM_GetValidBank();
extern void EEPROM_Erase();
extern void EEPROM_Read();
extern void EEPROM_Write();
extern void EEPROM_UpdateBankStatus();
extern void EEPROM_UpdatePageStatus();
extern void EEPROM_GetSinglePointer(Uint16 First_Call);
extern void EEPROM_ProgramSingleByte(Uint16 data);

// Global Variables
extern Uint16 *Bank_Pointer;
extern Uint16 *Page_Pointer;
extern Uint16 *Sector_End;
extern Uint16 Read_Buffer[64];
extern Uint16 Write_Buffer[64];	


