/*
 * Decompiled with CFR 0.152.
 */
package fileutilities;

import java.io.File;
import javafx.scene.control.Alert;
import javafx.scene.image.Image;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;

public final class FileUtilities {
    public static void ShowDialog(String title, String header, String content) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(content);
        Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
        stage.getIcons().add((Object)new Image(FileUtilities.class.getResourceAsStream("/images/TI_logo_small.png")));
        alert.showAndWait();
    }

    public static File ChooseFile(String title, String[] extentions) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(title);
        for (String extention : extentions) {
            fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(extention.substring(1).toUpperCase() + " File", new String[]{"*" + extention})});
        }
        File file = fileChooser.showOpenDialog(null);
        return file;
    }

    public static File ChooseFolder() {
        DirectoryChooser chooser = new DirectoryChooser();
        chooser.setTitle("Select Folder");
        File selectedDirectory = chooser.showDialog(null);
        return selectedDirectory;
    }
}

