----------------------------------------------------------------------------------
-- Company:  Spectrum Digital
-- Engineer: Tony C
-- 
-- Create Date:    2/21/2013
-- Design Name:    Video Mux 2
-- Module Name:     
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- 2/21/2013 - Initial Release
--
-- 4/2/2013  - Add a switch for mux/demux to match functionality in cpld 1.
--
-- 5/2/2013  - Change SW(7 downto 0) to SW( 8 downto 1) to match SW marking.
--
-- 7/12/2013 - TI Request
--   Apply the 8 bit camera shift to the FPD Link
--
-- Additional Comments: 
-- The 5M2210ZF256C5N or 324 will route at under 1ns of skew.  The 1270 will route
-- in -4 speed grade.  You have to let the tool select the pinout to meet skew.
-- Forcing the output into just 1 or 2 banks did not work.
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity video_mux2 is
port(

   DeMux_FPD_A     : in std_logic;
   DeMux_FPD_B     : in std_logic;
   DeMux_FPD_C     : in std_logic;
   
   cam2_d  	       : in std_logic_vector(9 downto 1 );
   cam4_d   	     : in std_logic_vector(9 downto 1 );
   cam5_d  	       : in std_logic_vector(9 downto 7 );
   cam6_d  	       : in std_logic_vector(9 downto 7 );
         
   cam2_hsync      : in std_logic;
   cam2_pclk       : in std_logic;
      
   cam4_hsync      : in std_logic;
   cam4_pclk       : in std_logic;
   
   cam5_hsync      : in std_logic;
   cam5_pclk       : in std_logic;
   
   cam6_hsync      : in std_logic;
   cam6_pclk       : in std_logic;
   
   cam2_d0_cam2_vs   : in std_logic;
   cam4_d0_cam4_vs   : in std_logic;
   cam5_d0_cam5_vs   : in std_logic;
   cam6_d0_cam6_vs   : in std_logic;
   
   --cam5_d1_cam1_vs   : in std_logic;  -- not used
   cam5_d2_cam1_d10  : in std_logic;
   cam5_d3_cam1_d11  : in std_logic;
   cam5_d4_cam2_vs   : in std_logic;
   cam5_d5_cam2_d10  : in std_logic;
   cam5_d6_cam2_d11  : in std_logic;
   
 
   cam6_d1_cam3_vs   : in std_logic;
   cam6_d2_cam3_d10  : in std_logic;
   cam6_d3_cam3_d11  : in std_logic;
   cam6_d4_cam4_vs   : in std_logic;
   cam6_d5_cam4_d10  : in std_logic;
   cam6_d6_cam4_d11  : in std_logic;
   
   vin2a 	         : out std_logic_vector(11 downto 0 );
   vin2a_pclk      : out std_logic;
   vin2a_hs        : out std_logic;
   vin2a_vs        : out std_logic;
    
   vin5a 	         : out std_logic_vector(11 downto 0 );
   vin5a_pclk      : out std_logic;
   vin5a_hs        : out std_logic;
   vin5a_vs        : out std_logic;
   
   vin4b 	         : out std_logic_vector(7 downto 0 );
   vin4b_pclk      : out std_logic;
   vin4b_hs        : out std_logic;
   vin4b_vs        : out std_logic;

   vin6a 	         : out std_logic_vector(9 downto 0 );
   vin6a_pclk      : out std_logic;
   vin6a_hs        : out std_logic;
   vin6a_vs        : out std_logic;
   tp              : out std_logic_vector(74 downto 55);
   sw              : in  std_logic_vector(8 downto 1));

end video_mux2;

architecture Behavioral of video_mux2 is
     
   constant   mode_8bit    : std_logic_vector( 2 downto 0 ) := "101";
   constant   mode_12bit   : std_logic_vector( 2 downto 0 ) := "010";
   
   signal cam6_dm  : std_logic_vector(  6 downto 0 );
   signal cam5_dm  : std_logic_vector(  6 downto 0 );
   signal cam4_dm  : std_logic_vector( 11 downto 10);
   signal cam2_dm  : std_logic_vector( 11 downto 10);
   
   signal cam2_d0  : std_logic;
   signal cam4_d0  : std_logic;
     
   signal cam2_vs : std_logic;
   signal cam4_vs : std_logic;
   signal cam5_vs : std_logic;
   signal cam6_vs : std_logic;
   
   signal vs_12bit         : std_logic;
   signal vs_8bit          : std_logic;
   
   signal cam2_vs8bit      : std_logic;
   signal cam2_vs12bit     : std_logic;
 
   signal cam4_vs8bit      : std_logic;
   signal cam4_vs12bit     : std_logic;
   
   signal sg_DeMux_FPD_A   : std_logic;
   signal sg_DeMux_FPD_B   : std_logic;
   signal sg_DeMux_FPD_C   : std_logic;
   
 

begin
    -- Switch(7) open or no switch installed use orignal selection.
    -- Switch(7) closed then use the switch selection inputs.
    sg_DeMux_FPD_A <= DeMux_FPD_A          when sw(8) = '1' else sw(5);
    sg_DeMux_FPD_B <= DeMux_FPD_B          when sw(8) = '1' else sw(6);
    sg_DeMux_FPD_C <= DeMux_FPD_C          when sw(8) = '1' else sw(7);
  
    vs_12bit <= '1' when     sg_DeMux_FPD_A = '0' 
                         and sg_DeMux_FPD_B = '1' 
                         and sg_DeMux_FPD_C = '0' else '0';
   
    vs_8bit <= '1' when      sg_DeMux_FPD_A = '1' 
                         and sg_DeMux_FPD_B = '0' 
                         and sg_DeMux_FPD_C = '1' else '0';
                       
   cam2_vs12bit <= cam5_d4_cam2_vs when vs_12bit = '1' else '0';
   cam2_vs8bit  <= cam2_d0_cam2_vs when vs_8bit  = '1' else '0'; 
   cam2_vs      <= cam2_vs12bit or cam2_vs8bit;

   cam4_vs12bit <= cam6_d4_cam4_vs when vs_12bit = '1' else '0';
   cam4_vs8bit  <= cam4_d0_cam4_vs when vs_8bit  = '1' else '0'; 
   cam4_vs      <= cam4_vs12bit or cam4_vs8bit;
   
   -- deMUX_FPD_A
   cam6_dm(1) <=cam6_d1_cam3_vs   when sg_DeMux_FPD_A = '1' else '0';
   cam6_dm(2) <=cam6_d2_cam3_d10  when sg_DeMux_FPD_A = '1' else '0';
   cam6_dm(3) <=cam6_d3_cam3_d11  when sg_DeMux_FPD_A = '1' else '0';
   cam6_dm(4) <=cam6_d4_cam4_vs   when sg_DeMux_FPD_A = '1' else '0';
   cam6_dm(5) <=cam6_d5_cam4_d10  when sg_DeMux_FPD_A = '1' else '0';
   cam6_dm(6) <=cam6_d6_cam4_d11  when sg_DeMux_FPD_A = '1' else '0';
 
   cam4_dm(10) <=cam6_d5_cam4_d10  when sg_DeMux_FPD_A = '0' else '0';
   cam4_dm(11) <=cam6_d6_cam4_d11  when sg_DeMux_FPD_A = '0' else '0';

   -- deMUX_FPD_B
   cam2_d0    <= cam2_d0_cam2_vs   when sg_DeMux_FPD_B = '1' else '0';
   cam4_d0    <= cam4_d0_cam4_vs   when sg_DeMux_FPD_B = '1' else '0';
   cam5_dm(0) <= cam5_d0_cam5_vs   when sg_DeMux_FPD_B = '1' else '0';
   cam6_dm(0) <= cam6_d0_cam6_vs   when sg_DeMux_FPD_B = '1' else '0';
   
   cam5_vs <= cam5_d0_cam5_vs   when sg_DeMux_FPD_B = '0' else '0';
   cam6_vs <= cam6_d0_cam6_vs   when sg_DeMux_FPD_B = '0' else '0';
  
   -- deMUX_FPD_C
   --cam5_dm(1) <= cam5_d1_cam1_vs   when DeMux_FPD_C = '1' else '0';
   cam5_dm(2) <= cam5_d2_cam1_d10  when sg_DeMux_FPD_C = '1' else '0';
   cam5_dm(3) <= cam5_d3_cam1_d11  when sg_DeMux_FPD_C = '1' else '0';
   cam5_dm(4) <= cam5_d4_cam2_vs   when sg_DeMux_FPD_C = '1' else '0';
   cam5_dm(5) <= cam5_d5_cam2_d10  when sg_DeMux_FPD_C = '1' else '0';
   cam5_dm(6) <= cam5_d6_cam2_d11  when sg_DeMux_FPD_C = '1' else '0';
   
   cam2_dm(10) <= cam5_d5_cam2_d10  when sg_DeMux_FPD_C = '0' else '0';
   cam2_dm(11) <= cam5_d6_cam2_d11  when sg_DeMux_FPD_C = '0' else '0';
   
   vin2a       <= cam2_dm(11) & cam2_dm(10) & cam2_d(9 downto 1) & cam2_d0
                  when vs_8bit = '0' else
                  "00" & cam2_dm(11) & cam2_dm(10) & cam2_d(9 downto 2);
   vin2a_pclk  <= cam2_pclk;
   vin2a_hs    <= cam2_hsync;
   vin2a_vs    <= cam2_vs;
               
   vin5a       <= cam4_dm(11) & cam4_dm(10) & cam4_d(9 downto 1) & cam4_d0
                  when vs_8bit = '0' else
                  "00" & cam4_dm(11) & cam4_dm(10) & cam4_d(9 downto 2);               
   vin5a_pclk  <= cam4_pclk;
   vin5a_hs    <= cam4_hsync;
   vin5a_vs    <= cam4_vs;           
 
   vin4b       <= cam5_d(9 downto 7)  & cam5_dm(6 downto 2); 
   vin4b_pclk  <= cam5_pclk;
   vin4b_hs    <= cam5_hsync;
   vin4b_vs    <= cam5_vs; 
   
   vin6a       <= cam6_d(9 downto 7)  & cam6_dm(6 downto 0)
                  when vs_8bit = '0' else
                  "00" & cam6_d(9 downto 7)  & cam6_dm(6 downto 2);
   
   vin6a_pclk  <= cam6_pclk;
   vin6a_hs    <= cam6_hsync;
   vin6a_vs    <= cam6_vs; 

   
   tp(62 downto 59) <= (others => 'Z');

   tp( 70 downto 63) <= sw( 8 downto 1);
   
   tp(55) <= cam2_hsync;
   tp(56) <= cam2_vs;
   tp(57) <= cam4_hsync;
   tp(58) <= cam4_vs;
   tp(71) <= cam5_hsync;
   tp(72) <= cam5_vs;
   tp(73) <= cam6_hsync;
   tp(74) <= cam6_vs;                
end Behavioral;
