% **************************************************************************************************
%   Filename:       dataHandler.m
%   Revised:        $Date: 2011-07-23 $
%   Revision:       $Revision:  $
% 
%   Description:    Class definition for dataHandler Class
% 
% 
%   Copyright 2009-2010 Texas Instruments Incorporated. All rights reserved.
% 
%   IMPORTANT: Your use of this Software is limited to those specific rights
%   granted under the terms of a software license agreement between the user
%   who downloaded the software, his/her employer (which must be your employer)
%   and Texas Instruments Incorporated (the "License").  You may not use this
%   Software unless you agree to abide by the terms of the License. The License
%   limits your use, and you acknowledge, that the Software may not be modified,
%   copied or distributed unless embedded on a Texas Instruments microcontroller
%   or used solely and exclusively in conjunction with a Texas Instruments radio
%   frequency transceiver, which is integrated into your product.  Other than for
%   the foregoing purpose, you may not use, reproduce, copy, prepare derivative
%   works of, modify, distribute, perform, display or sell this Software and/or
%   its documentation for any purpose.
% 
%   YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
%   PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
%   INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
%   NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
%   TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
%   NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
%   LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
%   INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE
%   OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT
%   OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
%   (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.
% 
%   Should you have any questions regarding your right to use this Software,
%   contact Texas Instruments Incorporated at www.TI.com.
% **************************************************************************************************

classdef dataHandler < handle & hgsetget
properties
   
    data = {[];[];[];[];[]};
    stat_thres = 10;
    touch_thres = 20;
    variance_multiplier = 2;

    history_length = 200;
end

methods
    % Constructor
    function obj = dataHandler(handles)
        obj.stat_thres  = str2double(get(handles.edit_statThres, 'String'));
        obj.touch_thres = str2double(get(handles.edit_touchThres, 'String'));
        obj.history_length = str2double(get(handles.edit_history, 'String'));
        obj.variance_multiplier = str2double(get(handles.edit_varMultiplier, 'String'));
    end

    function newDataHandler(obj, src, data, handles )
        % One iteration for every button.
        for( n = length(data):-1:1 )
            % Add variance*multiplier to mean and store
            data{n}(5) = data{n}(2) + data{n}(3)*obj.variance_multiplier;
            % Calculate threshold values
            data{n}(3) = data{n}(2) + obj.stat_thres;   % stat_thres
            data{n}(4) = data{n}(2) + obj.touch_thres;  % touch_thres'
            % Save data
            obj.data{n} = [obj.data{n} data{n}];
        end
        obj.updatePlot(handles);
    end  

    function dumpDataToWorkspace(obj)
        assignin('base', 'capsense_data', obj.data);
    end

    function clearData(obj)
        % empty stored data
        obj.data = cell(1,5);
    end

    function updatePlot(obj,handles)    
%         XData = 0:1:obj.history_length-1;
        XData = obj.history_length:-1:1;
        % loop through plots (buttons)
        for( n = size(handles.plots,1):-1:1 )
            % loop through lines in current plot
            for( m = size(handles.plots,2):-1:1 )
                len = size(obj.data{n},2); % number of samples collected since start
                if( len < obj.history_length )
                    YData = [zeros(1,(obj.history_length - len)) obj.data{n}(m,:)];
                else
                    YData = obj.data{n}(m,len-obj.history_length+1:len);
                end
                % A specific line is now selected, update it with new data
                set( handles.plots{n,m},'XData', XData, 'YData', YData );
            end            
        end 
    end
end
end




