function [ avg ] = Calc_avg( data, Sw, RBW, k )
%Calc_avg converts input data from dBm to milliwatts and calculates average
%according to the formulae on page 20.

% Convert from dBm to milliwatts
data = 10.^(data/10);

if(Sw == 0)
    avg = mean(data);
else
    % Sum, See 4(15) page 20
    avg = sum(data) * Sw/(RBW*k*length(data));
end


end

