function [ y, x ] = Read_data( dev, Fmin, Fmax, cLoss, wait_stable )
%Read_data reads data from Spectrum Analyzer
%dev: GBIB-device
%Fmin: start frequency
%Fmax: stop frequency
%cLoss: Loss in Tx path
%wait_stable: ON waits for the spectrum analyzer to stabilize

disp(['Reading data from ', num2str(Fmin), ' to ' num2str(Fmax), ' MHz...']);
dev.scmd([':FORM ASCII;']);
pause(1);

% if Sweep mode is set to continuous, delay is set to current sweeptime
% dev.scmd(['INIT;*WAI';]); will start a sweep.
% else delay = 0, dev.scmd(['INIT;*WAI';]); will start a sweep and wait for
% it to finish.
if(str2num(dev.ask(['INIT:CONT?';])))
    delay = str2num(dev.ask(['SWE:TIME?';]));
else
    delay = 0;
end    

if(strcmp(wait_stable, 'ON'))
    sty = 0;
    i = 0;
    diff = 1000;
    %        sensitivity && max iterations
    while(diff > 0.00008 && i < 70)
        sty1 = sty;
        i = i + 1;
        pause(0.2); 
        dev.scmd(['INIT;*WAI';]); % See comment above regarding delay.
        pause(delay);
        % Read trace and convert to numbers.
        y = dev.ask([':TRAC? TRACE1;']);
        y = regexp(y,',', 'split');
        % Compenstate for cable loss
        y=str2double(y) + cLoss;
        sty = std(y);
        % Calculate the difference in standard deviation of 
        % actual and previous sweep to see if signal is stable.
        diff = abs(sty1-sty);
    end
    if(i==70)
        disp('Stabilisation timeout. Using latest measure.');
    end
else
    dev.scmd(['INIT;*WAI';]);
    pause(delay);
    % Read trace and convert to numbers.
    y = dev.ask([':TRAC? TRACE1;']);
    y = regexp(y,',', 'split');
    % Compenstate for cable loss
    y=str2double(y) + cLoss;
end

% Generate frequency vector.
x = linspace(Fmin, Fmax, length(y));

end

