function [ finalarr ] = Arrconcat( varargin )
% Arrconcat concatenates an arbitrary number of arrays with arbitrary length
% each into one long array.
% The code uses string manipulation to generate a final code that is
% executed using eval.

% n: number of arguments
n = nargin;
% varargin(index) accesses the arbitrary argument with the specified index
arrstr = ' varargin{';
% the index for varargin as a string
nrstr = '0';
% the final expression is stored in endstr at the end of the code
endstr = '';

% Generate code from each argument and store in endstr
for i = 1:n
    nrstr = int2str(i);
    endstr = strcat(endstr, arrstr, nrstr, '}');
end

% Finish endstr to the form "finalarr = [ varargin{1} varargin{2} ... ];"
endstr = strcat('finalarr = [', endstr, ' ];');

% Execute endstr
eval(endstr);

end
