function [ output ] = Spec_an_setup(dev, Fmin, Fmax, RBW, VBW, datap, contsweep, detmode, mxhld, ref, att )
%Spec_an_setup sets up the Spectrum Analyzer
% dev: gpib device
% Fmin: start frequency (MHz)
% Fmax: stop frequency (MHz)
% Sw: Sweep frequency band (MHz)
% RBW: Resolution bandwidth (MHz)
% VBW: Video bandwidth (MHz)
% datap: Data points
% contsweep: Sweep mode: Continuous ON/OFF
% detmode: Detection mode: Positive Peak / Sample
% mxhld: Display Mode: Max Hold ON/OFF
% ref: Reference level AUTO or user defined
% att: Attenuation

% Start- and stop frequency
dev.scmd(['FREQ:STAR' blanks(1) num2str(Fmin) blanks(1) 'MHz';]);
dev.scmd(['FREQ:STOP' blanks(1) num2str(Fmax) blanks(1) 'MHz';]);
% Resolution- and video bandwidth
dev.scmd(['BAND:RES' blanks(1) num2str(RBW) blanks(1) 'MHz';]);
dev.scmd(['BAND:VID' blanks(1) num2str(VBW) blanks(1) 'MHz';]);
% 100 dB (dBm) range on the spectrum analyzer, 100/10 = 10 dB/div
dev.scmd(['DISP:TRAC:Y' blanks(1) num2str(100) 'dB';]);
% Sweep time: auto
dev.scmd(['SWE:TIME:AUTO' blanks(1) 'ON';]);
% Number of data points
dev.scmd(['SWE:POIN' blanks(1) num2str(datap);]);

% Continuous- or single sweep
if(strcmp(contsweep, 'ON'))
    dev.scmd(['INIT:CONT' blanks(1) 'ON';]);
else
    dev.scmd(['INIT:CONT' blanks(1) 'OFF';]);
end

% Detection mode: Positive peak, else Sample
if(strcmp(detmode, 'POSP'))
    dev.scmd(['DET' blanks(1) 'POS';]);
else
    dev.scmd(['DET' blanks(1) 'SAMPL';]);
end

% Display mode: Max hold, else clear/write
if(strcmp(mxhld, 'ON'))
    dev.scmd(['DISP:WIND:TRAC:MODE' blanks(1) 'MAXH';]);
else
    dev.scmd(['DISP:WIND:TRAC:MODE' blanks(1) 'WRIT';]);
end

% Auto attenuation, Else user defined.
if(strcmp(att, 'AUTO'))
    dev.scmd(['INP:ATT:AUTO' blanks(1) 'ON';]);
else
    dev.scmd(['INP:ATT' blanks(1) num2str(att);]);
end

% Reference level auto sets the reference level to the first 20 dBm higher than
% the maximum peak, Else user defined.
if(strcmp(ref, 'AUTO'))
    y = Read_data(dev, Fmin, Fmax, 'OFF');
    dev.scmd(['DISP:TRAC:Y:RLEV' blanks(1) num2str(round((max(y)+20)/10)*10) 'dBm';]);
else
    dev.scmd(['DISP:TRAC:Y:RLEV' blanks(1) num2str(ref) 'dBm';]);
end


% Delay that lets the spectrum analyzer set
pause(2);

end

