clear; clc; close all; set(0,'DefaultFigureWindowStyle','docked');
% DAC8811 Iout Internal Resistance to GND

%% EQUATIONS
syms B1 B2 B3 B4 B5 B6 B7 B8 B9 B10 B11 B12 B13 B14 B15 B16
syms V1 V2 V3 V4 V5 V6 V7 V8 V9 V10 V11 V12 V13...
    V14 V15 V16 V17

%Equations will depend on the architecture used for the R-2R ladder
%   16 bit DAC, 3 upper bits segmented B1, B2, B3
%   The segmentation causes V1, V2 and V3 to be connected to Vref.
%   Vref is shorted to GND during this equivalent resistance analysis.
%   These are not included in the substitution equations.
%   V17 is the last leg of the ladder which is always connected to GND.
V1 = 0; V2 = 0; V3 = 0; V17 = 0;

%Define equations (Format is different from the word file, same eq.)
f4  = (5*V4-B4)/2 - (V3+V5);
f5  = (5*V5-B5)/2 - (V4+V6);
f6  = (5*V6-B6)/2 - (V5+V7);
f7  = (5*V7-B7)/2 - (V6+V8);
f8  = (5*V8-B8)/2 - (V7+V9);
f9  = (5*V9-B9)/2 - (V8+V10);
f10 = (5*V10-B10)/2 - (V9+V11);
f11 = (5*V11-B11)/2 - (V10+V12);
f12 = (5*V12-B12)/2 - (V11+V13);
f13 = (5*V13-B13)/2 - (V12+V14);
f14 = (5*V14-B14)/2 - (V13+V15);
f15 = (5*V15-B15)/2 - (V14+V16);
f16 = (2*V16-V15) - (B16+V17)/2;   %Last equation IS different.

%First round of substitution
V4  = solve(f4, V4);
V5  = solve(subs(f5), V5);
V6  = solve(subs(f6), V6);
V7  = solve(subs(f7), V7);
V8  = solve(subs(f8), V8);
V9  = solve(subs(f9), V9);
V10 = solve(subs(f10), V10);
V11 = solve(subs(f11), V11);
V12 = solve(subs(f12), V12);
V13 = solve(subs(f13), V13);
V14 = solve(subs(f14), V14);
V15 = solve(subs(f15), V15);
V16 = solve(subs(f16), V16);

%Second round of substitution (Set all eqs. in terms of V1, V2, V3...)
V15 = subs(V15);
V14 = subs(V14);
V13 = subs(V13);
V12 = subs(V12);
V11 = subs(V11);
V10 = subs(V10);
V9  = subs(V9);
V8  = subs(V8);
V7  = subs(V7);
V6  = subs(V6);
V5  = subs(V5);
V4  = subs(V4);

%Set equations into Matrix form
V = [V1,V2,V3,V4,V5,V6,V7,V8,V9,V10,V11,V12,V13,V14,V15,V16];
B = [B1,B2,B3,B4,B5,B6,B7,B8,B9,B10,B11,B12,B13,B14,B15,B16];

A = double(equationsToMatrix(V,B));


%% ITERATION
Rof = zeros(2^16,1); i = 0; %Allocate space and reset counter
R = 1;
%Loop through all code possibilities
for B1  = 0:1
for B2  = 0:1
for B3  = 0:1
for B4  = 0:1
for B5  = 0:1
for B6  = 0:1
for B7  = 0:1
for B8  = 0:1
for B9  = 0:1
for B10 = 0:1
for B11 = 0:1
for B12 = 0:1
for B13 = 0:1
for B14 = 0:1
for B15 = 0:1
for B16 = 0:1
    i = i+1;
    B = [B1,B2,B3,B4,B5,B6,B7,B8,B9,B10,B11,B12,B13,B14,B15,B16]'; %Code
    X = A*B; %Vector containing voltages at each node
    %The current from each leg is added. The first 3-bits are segmented
    Iout = double(4*B(1)/(2*R) + 2*B(2)/(2*R) + B(3)/(2*R) +...
        B(4)*(B(4)-X(4))/(2*R) + B(5)*(B(5)-X(5))/(2*R) +...
        B(6)*(B(6)-X(6))/(2*R) + B(7)*(B(7)-X(7))/(2*R) +...
        B(8)*(B(8)-X(8))/(2*R) + B(9)*(B(9)-X(9))/(2*R) +...
        B(10)*(B(10)-X(10))/(2*R) + B(11)*(B(11)-X(11))/(2*R) +...
        B(12)*(B(12)-X(12))/(2*R) + B(13)*(B(13)-X(13))/(2*R) +...
        B(14)*(B(14)-X(14))/(2*R) + B(15)*(B(15)-X(15))/(2*R) +...
        B(16)*(B(16)-X(16))/(2*R));
   
    Rof(i) = 1/Iout; %Convert current into resistance (V = 1V)
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end

%% RESULTS
%DAC Absolute Max
x = [0:65535]'; %Code vector
G = 1+(0.25)./Rof;  %Gain vector
minRof = min(Rof)
[maxGain maxGain_code] = max(G);
maxGain
maxGain_code = maxGain_code - 1

%Plots
%Figure 1
figure; plot(x, Rof);
hold on; plot(maxGain_code, minRof, 'r*');
title('Code vs. Ros'); xlabel('Code'); ylabel('Ros');
text(maxGain_code*(1/2), .6, 'Min Ros = 0.188 @ Code = 64171')

%Figure 2
figure; plot (x, G);
hold on; plot(maxGain_code, maxGain, 'r*');
title('Code vs. Vos Gain'); xlabel('Code'); ylabel ('Vos Gain: (.25)/(Ros)');
text(maxGain_code*(1/2), 2.4, 'Max Gain = 2.33 @ Code = 64171');

p = polyfit(x, G, 1);
y = p(1)*x + p(2);
plot(x, y, 'r.');


% %Figure 3
figure; plot(x, G-y); hold on;

maxINL = max(G-y);
minINL = min(G-y);
title('INL of Vos Gain'); xlabel('Code'); ylabel('Gain - Line of best fit');
axis ([1,2^16,-.3,.1])

%% SPECIFIC CODE
% In case you need to calculate the Ros of a specific code
% B = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]';
% X = A*B;
% Iout = double(4*B(1)/(2*R) + 2*B(2)/(2*R) + B(3)/(2*R) +...
%     B(4)*(B(4)-X(4))/(2*R) + B(5)*(B(5)-X(5))/(2*R) +...
%     B(6)*(B(6)-X(6))/(2*R) + B(7)*(B(7)-X(7))/(2*R) +...
%     B(8)*(B(8)-X(8))/(2*R) + B(9)*(B(9)-X(9))/(2*R) +...
%     B(10)*(B(10)-X(10))/(2*R) + B(11)*(B(11)-X(11))/(2*R) +...
%     B(12)*(B(12)-X(12))/(2*R) + B(13)*(B(13)-X(13))/(2*R) +...
%     B(14)*(B(14)-X(14))/(2*R) + B(15)*(B(15)-X(15))/(2*R) +...
%     B(16)*(B(16)-X(16))/(2*R));
% 1/Iout