//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  July 22, 2010
//  Built with IAR Embedded Workbench Version: 3.42A
//******************************************************************************
#include "Config.h"

char StatusLED;
int Frequency[6];

char Device;
int MS_Index;
int AccelRate, DesiredStepperSpeed;
int tmpAccelTimeBase, AccelTimeBase;
int AccelerateState;
int StepsToMove;
bool MoveSteps, MS_Direction;

void Task0(void)
{
if (MessageComplete)
    {
      SerialOutBuffer[0] = FIRMWARE_REVISION;
      SerialOutBuffer[1] = 0;
      SerialOutBuffer[2] = 0;
      int tempOut;
      switch(OPCODE)
      {
// Write GPIO Data [ OPCODE = 3 ] [ GPIO DATA ] [ Not Used ] [ Not Used ] [ Not Used ]
// GPIO DATA = P47/P46/P45/P44/NO/NO/P41/NO
      case (WRITE_GPIO):
            P4OUT = SerialBuffer[1];
            SerialOutBuffer[1] = ~SerialBuffer[1];
            break;
// DAC 0 Config and Write [ OPCODE = 5 ] [ Config HB ] [ Config LB ] [ Data HB ] [ Data LB ]
      case (DAC0_UPDATE):
            DAC12_0CTL = 0;
            DAC12_0CTL = (SerialBuffer[1] * 256) + SerialBuffer[2];
            DAC12_0DAT = (SerialBuffer[3] * 256) + SerialBuffer[4];
            break;
// DAC 1 Config and Write [ OPCODE = 6 ] [ Config HB ] [ Config LB ] [ Data HB ] [ Data LB ]
      case (DAC1_UPDATE):
            DAC12_1CTL = 0;
            DAC12_1CTL = (SerialBuffer[1] * 256) + SerialBuffer[2];
            DAC12_1DAT = (SerialBuffer[3] * 256) + SerialBuffer[4];
            break;
            // Case (TMP0): break; //Opcode 7
// Enable PWM [ OPCODE = 0x0B ] [ Timer # ] [ Duty Cycle ] [ Not Used ] [ Not Used ]
      case (ENABLE_PWM):
        TBCTL |= TB_CNTL_08;                //Configure Timer to run up to FF (8 bit FRC)

        switch (SerialBuffer[1])
        {
        case 0:
            TBCCR0 = SerialBuffer[2];
            tempOut = TBCCTL0;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            TBCCTL0 = tempOut;
        break;
        case 1:
            TBCCR1 = SerialBuffer[2];
            tempOut = TBCCTL1;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            TBCCTL1 = tempOut;
        break;
        case 2:
            TBCCR2 = SerialBuffer[2];
            tempOut = TBCCTL2;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            TBCCTL2 = tempOut;
        break;
        case 3:
            TBCCR3 = SerialBuffer[2];
            tempOut = TBCCTL3;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            TBCCTL3 = tempOut;
        break;
        case 4:
            TBCCR4 = SerialBuffer[2];
            tempOut = TBCCTL4;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            TBCCTL4 = tempOut;
        break;
        case 5:
            TBCCR5 = SerialBuffer[2];
            tempOut = TBCCTL5;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            TBCCTL5 = tempOut;
        break;
        }
      break;
// Disable PWM [ OPCODE = 0x0C ] [ Timer # ] [ Not Used ] [ Not Used ] [ Not Used ]
      case (DISABLE_PWM):

        //(TBCCTL0 + SerialBuffer[1]) &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCTL0 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 1:
            TBCCTL1 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 2:
            TBCCTL2 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 3:
            TBCCTL3 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 4:
            TBCCTL4 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 5:
            TBCCTL5 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 6:
            TBCCTL6 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        }
      break;
// Enable PWM [ OPCODE = 0x0D ] [ Timer # ] [ Duty Cycle ] [ Not Used ] [ Not Used ]
      case (UPDATE_PWM):
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCR0 = SerialBuffer[2];
        break;
        case 1:
            TBCCR1 = SerialBuffer[2];
        break;
        case 2:
            TBCCR2 = SerialBuffer[2];
        break;
        case 3:
            TBCCR3 = SerialBuffer[2];
        break;
        case 4:
            TBCCR4 = SerialBuffer[2];
        break;
        case 5:
            TBCCR5 = SerialBuffer[2];
        break;
        case 6:
            TBCCR6 = SerialBuffer[2];
        break;
        }
            break;
// Set Timer Output [ OPCODE = 0x0E ] [ Timer # ] [ Not Used ] [ Not Used ] [ Not Used ]
      case (SET_TMR_OUT):
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCTL0 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL0 |= BIT2;                  // Set OUT
          break;
        case 1:
            TBCCTL1 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL1 |= BIT2;                  // Set OUT
          break;
        case 2:
            TBCCTL2 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL2 |= BIT2;                  // Set OUT
          break;
        case 3:
            TBCCTL3 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL3 |= BIT2;                  // Set OUT
          break;
        case 4:
            TBCCTL4 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL4 |= BIT2;                  // Set OUT
          break;
        case 5:
            TBCCTL5 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL5 |= BIT2;                  // Set OUT
          break;
        case 6:
            TBCCTL6 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL6 |= BIT2;                  // Set OUT
          break;
        }
        break;
        // Pulse Timer Output [ OPCODE = 0x0F ] [Timer Used] [ Pulse Length Hi ] [ Pulse Length Lo ] [ Not Used ]
      case (PULSE_TMR):
        TBCTL &= ~TB_CNTL_08;                //Configure Timer to run up to FFFF (16 bit FRC)
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCTL0 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL0 |= TB_OUT_HIGH;                                     //Set the output (pulse start)
            TBCCTL0 |= TB_OUTMOD_RESET;                                 //Configure the timer to reset
            TBCCR0 = TBR + ((SerialBuffer[2] * 256) + SerialBuffer[3]); //Configure the pulse reset time (pulse end)
          break;
        case 1:
            TBCCTL1 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL1 |= TB_OUT_HIGH;                                     //Set the output (pulse start)
            TBCCTL1 |= TB_OUTMOD_RESET;                                 //Configure the timer to reset
            TBCCR1 = TBR + ((SerialBuffer[2] * 256) + SerialBuffer[3]); //Configure the pulse reset time (pulse end)
          break;
        case 2:
            TBCCTL2 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL2 |= TB_OUT_HIGH;                                     //Set the output (pulse start)
            TBCCTL2 |= TB_OUTMOD_RESET;                                 //Configure the timer to reset
            TBCCR2 = TBR + ((SerialBuffer[2] * 256) + SerialBuffer[3]); //Configure the pulse reset time (pulse end)
          break;
        case 3:
            TBCCTL3 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL3 |= TB_OUT_HIGH;                                     //Set the output (pulse start)
            TBCCTL3 |= TB_OUTMOD_RESET;                                 //Configure the timer to reset
            TBCCR3 = TBR + ((SerialBuffer[2] * 256) + SerialBuffer[3]); //Configure the pulse reset time (pulse end)
          break;
        }
        break;
// Set Timer Frequency [ OPCODE = 0x10 ] [ Timer # ] [ Frequency Hi ] [ Frequency Lo ] [ Not Used ]
      case (FREQ_TMR):
        TBCTL &= ~TB_CNTL_08;                //Configure Timer to run up to FFFF (16 bit FRC)
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCTL0 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL0 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            Frequency[0] = (SerialBuffer[2] * 256) + SerialBuffer[3];   //Configure the Frequency Rate
            TBCCR0 = Frequency[0];
            break;
        case 1:
            TBCCTL1 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL1 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            Frequency[1] = (SerialBuffer[2] * 256) + SerialBuffer[3];   //Configure the Frequency Rate
            TBCCR1 = Frequency[1];
            break;
        case 2:
            TBCCTL2 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL2 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            Frequency[2] = (SerialBuffer[2] * 256) + SerialBuffer[3];   //Configure the Frequency Rate
            TBCCR2 = Frequency[2];
            break;
        case 3:
            TBCCTL3 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL3 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            Frequency[3] = (SerialBuffer[2] * 256) + SerialBuffer[3];   //Configure the Frequency Rate
            TBCCR3 = Frequency[3];
            break;
        }
      break;
// Disable Timer Frequency [ OPCODE = 0x11 ] [ Timer # ] [ Not Used ] [ Not Used ] [ Not Used ]
      case (FREQ_TMR_STOP):
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCTL0 &= 0xFF0F;                                          //Disable CC and Interrupt
            break;
        case 1:
            TBCCTL1 &= 0xFF0F;                                          //Disable CC and Interrupt
            break;
        case 2:
            TBCCTL2 &= 0xFF0F;                                          //Disable CC and Interrupt
            break;
        case 3:
            TBCCTL3 &= 0xFF0F;                                          //Disable CC and Interrupt
            break;
        }
         break;
// PWM16 SETUP [ OPCODE = 0x14 ] [ ENDIS {7}; DIVIDER {5:4}; PWM SIZE {3:2}; Timer # {1:0} ] [ HIGH Duty Cycle ] [ LO Duty Cycle ] [ Not Used ]
        //PWM SIZE: 00b = 16 bit; 01b = 12 bit; 10b = 10 bit; 11b = 8 bit
        //DIVIDER: 00b = /1; 01b = /2; 10b = /4; 11b = /8
      case (PWM16_SETUP):
        TBCTL &= 0xE73F;                   //Clear Counter Length Bits [12:11] and Input Divider bits [7:6]
        tempOut = (SerialBuffer[1] * 512); //Move bits 3:2 on SerialBuffer[1] to bits 12:11 on TBCTL
        tempOut |= (SerialBuffer[1] * 4);  //Move bits 5:4 on SerialBuffer[1] to bits 7:6 on TBCTL
        tempOut &= 0x18C0;                 //Mask bits 12:11 and 7:6 from being cleared.
        TBCTL |= tempOut;                  //Configure Timer to run up to PWM SIZE at a DIVIDER rate.

        switch (SerialBuffer[1] & 0x03)
        {
        case 0:
            TBCCR0 = (SerialBuffer[2] * 256 + SerialBuffer[3]);
            tempOut = TBCCTL0;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            if (SerialBuffer[1] & 0x80)
                {
                TBCCTL0 = tempOut;
                }
            else
                {
                TBCCTL0 &= 0xFF1B;            //Disable CC and Interrupt
                }
        break;
        case 1:
            TBCCR1 = (SerialBuffer[2] * 256 + SerialBuffer[3]);
            tempOut = TBCCTL1;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            if (SerialBuffer[1] & 0x80)
                {
                TBCCTL1 = tempOut;
                }
            else
                {
                TBCCTL1 &= 0xFF1B;            //Disable CC and Interrupt
                }
        break;
        case 2:
            TBCCR2 = (SerialBuffer[2] * 256 + SerialBuffer[3]);
            tempOut = TBCCTL2;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            if (SerialBuffer[1] & 0x80)
                {
                TBCCTL2 = tempOut;
                }
            else
                {
                TBCCTL2 &= 0xFF1B;            //Disable CC and Interrupt
                }
        break;
        case 3:
            TBCCR3 = (SerialBuffer[2] * 256 + SerialBuffer[3]);
            tempOut = TBCCTL3;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            if (SerialBuffer[1] & 0x80)
                {
                TBCCTL3 = tempOut;
                }
            else
                {
                TBCCTL3 &= 0xFF1B;            //Disable CC and Interrupt
                }
        break;
        }
      break;

// GPIO 0-1-2_AS_TIMER [ OPCODE = 0x15 ] [ ENDIS {7}; DIVIDER {5:4}; PWM SIZE {3:2}; Timer # {1:0} ] [ HIGH Duty Cycle ] [ LO Duty Cycle ] [ Not Used ]
        //PWM SIZE: 00b = 16 bit; 01b = 12 bit; 10b = 10 bit; 11b = 8 bit
        //DIVIDER: 00b = /1; 01b = /2; 10b = /4; 11b = /8
      case (GPIO_TIMER):
        TBCTL &= 0xE73F;                   //Clear Counter Length Bits [12:11] and Input Divider bits [7:6]
        tempOut = (SerialBuffer[1] * 512); //Move bits 3:2 on SerialBuffer[1] to bits 12:11 on TBCTL
        tempOut |= (SerialBuffer[1] * 4);  //Move bits 5:4 on SerialBuffer[1] to bits 7:6 on TBCTL
        tempOut &= 0x18C0;                 //Mask bits 12:11 and 7:6 from being cleared.
        TBCTL |= tempOut;                  //Configure Timer to run up to PWM SIZE at a DIVIDER rate.

        switch (SerialBuffer[1] & 0x03)
        {
        case 0:
            TBCCR4 = (SerialBuffer[2] * 256 + SerialBuffer[3]);
            tempOut = TBCCTL4;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            if (SerialBuffer[1] & 0x80)
                {
                TBCCTL4 = tempOut;
                P4SEL |= BIT4;              //Port pin is used as Peripheral
                P4DIR |= BIT4;              //Port pin is set to output
                }
            else
                {
                TBCCTL4 &= 0xFF1B;          //Disable CC and Interrupt
                P4SEL &= ~BIT4;             //Port pin is set to GPIO
                P4DIR &= ~BIT4;             //Port pin is set to input
                }
        break;
        case 1:
            TBCCR5 = (SerialBuffer[2] * 256 + SerialBuffer[3]);
            tempOut = TBCCTL5;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            if (SerialBuffer[1] & 0x80)
                {
                TBCCTL5 = tempOut;
                P4SEL |= BIT5;
                P4DIR |= BIT5;
                }
            else
                {
                TBCCTL5 &= 0xFF1B;            //Disable CC and Interrupt
                P4SEL &= ~BIT5;
                P4DIR &= ~BIT5;
                }
        break;
        case 2:
            TBCCR6 = (SerialBuffer[2] * 256 + SerialBuffer[3]);
            tempOut = TBCCTL6;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            if (SerialBuffer[1] & 0x80)
                {
                TBCCTL6 = tempOut;
                P4SEL |= BIT6;
                P4DIR |= BIT6;
                }
            else
                {
                TBCCTL6 &= 0xFF1B;            //Disable CC and Interrupt
                P4SEL &= ~BIT6;
                P4DIR &= ~BIT6;
                }
        break;
        }
      break;

// Write GPIO Data on SPI Port[ OPCODE = 0x16 ] [ GPIO DATA ] [ Not Used ] [ Not Used ] [ Not Used ]
// GPIO DATA = xx/xx/xx/xx/P53/P52/P51/P50
      case (SPI_GPIO):

            tempOut = P5OUT;
            tempOut &= 0xF0;                            //Clear 4 MSB in original Output Register
            tempOut |= SerialBuffer[1];
            P5OUT = tempOut;

            SerialOutBuffer[1] = ~SerialBuffer[1];
            break;

// START STEPPER [ OPCODE = 0x17 ] [ Frequency Hi ] [ Frequency Lo ] [ Accel Rate ] [ Accel Time Base ]
      case (START_STEPPER):
            TBCCTL3 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL3 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            DesiredStepperSpeed = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            AccelRate = SerialBuffer[3];
            AccelTimeBase = SerialBuffer[4];
            tmpAccelTimeBase = AccelTimeBase;
            Frequency[STEP_TIMER_NUMBER] = 0xFFFF;                                       //Slowest Startup Speed
            TBCCR3 = Frequency[STEP_TIMER_NUMBER];
            AccelerateState = ACCEL;
        break;
// STOP STEPPER [ OPCODE = 0x18 ] [ Frequency Hi ] [ Frequency Lo ] [ Not Used ] [ Not Used ]
      case (STOP_STEPPER):
            AccelerateState = STOP;
            DesiredStepperSpeed = 0xFF00;                               //Speed to stop at
            tmpAccelTimeBase = AccelTimeBase;
      break;
// STEPPER_SPEED [ OPCODE = 0x19 ] [ Frequency Hi ] [ Frequency Lo ] [ Accel Rate ] [ Accel Time Base ]
      case (STEPPER_SPEED):
            TBCCTL3 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL3 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            DesiredStepperSpeed = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            AccelRate = SerialBuffer[3];
            AccelTimeBase = SerialBuffer[4];
            tmpAccelTimeBase = AccelTimeBase;
            if ((unsigned int)DesiredStepperSpeed < (unsigned int)Frequency[STEP_TIMER_NUMBER])
            {
                AccelerateState = ACCEL;
            }
            else
            {
                AccelerateState = DECEL;
            }
      break;
// MOVE_STEPS [ OPCODE = 0x20 ] [ Frequency Hi ] [ Frequency Lo ] [ STEPS Hi ] [ STEPS Lo ]
      case (MOVE_STEPS):
            TBCCTL3 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL3 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            Frequency[STEP_TIMER_NUMBER] = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            StepsToMove = (SerialBuffer[3] * 256) + SerialBuffer[4];   //Configure the Frequency Rate
            TBCCR3 = Frequency[STEP_TIMER_NUMBER];
            MoveSteps = true;
            break;

// Send Universal SPI [Opcode = 0x42 ] [ Config ] [ Data 24] [ Data 16 ] [ Data 8 ]
// CONFIG [CKPH] [CKPL] [CSP] [NU] [NU] [NU] [# Bytes (00:10)]
      case (UNIV_SPI):
            int NumberOfBytes, i;

            NumberOfBytes = SerialBuffer[1] & 0x03;             // Extract Number of Bytes to Be Sent
            U1TCTL &= 0x3F;                                     // Clear CKPH and CKPL
            U1TCTL |= (SerialBuffer[1] & 0xC0);                 // Set CKPL
            //P5DIR = 0xFB;                                       // MISO is Input, others are output

            if (SerialBuffer[1] & 0x20)
                {
                P5OUT |= SLAVE_SEL;
                }
            else
                {
                P5OUT &= ~SLAVE_SEL;          //Start Slave Selection Negated
                }
            if (SerialBuffer[1] & 0x04)
                {
                P4DIR &= ~BIT5;           //Input
                P4SEL &= ~BIT5;           //IO
                }

            SerialOutBuffer[0] = U1RXBUF;
            for (i = 0; i < NumberOfBytes; i++)
            {
                while ((IFG2 & UTXIFG1) == 0);
                U1TXBUF = SerialBuffer[2 + i];
                while ((IFG2 & URXIFG1) == 0);
                SerialOutBuffer[i] = U1RXBUF;
            }
            while ((U1TCTL & TXEPT) == 0);
            if (SerialBuffer[1] & 0x20)
             {
             P5OUT &= ~SLAVE_SEL;
             }
           else
             {
             P5OUT |= SLAVE_SEL;          //Stop Slave Selection
             }

            break;

            // 8812 Microstepping Sine Wave Generator [ OPCODE = 0x50 ] [ FREQ HI ] [ FREQ LO ] [ EMPTY : CW/CCW : EN/DIS ] [ Not Used ]
      case (MICRO_STEP_8812):
            TBCCTL4 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            Frequency[4] = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            TBCCR4 = Frequency[4];
            DAC12_0CTL = 0x0142;
            DAC12_1CTL = 0x0142;
            MS_Index = 0;
            if (SerialBuffer[3] & BIT1)
            {
              MS_Direction = true;
            }
            else
            {
              MS_Direction = false;
            }
            if (SerialBuffer[3] & BIT0)
            {
            TBCCTL4 |= CCIE;                                            //Configure the timer to interrupt
            TBCCTL2 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL2 |= BIT2;                  // Set OUT
            TBCCTL3 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL3 |= BIT2;                  // Set OUT
            }
            else
            {
            TBCCTL4 &= ~CCIE;                                            //Disable the Timer Interrupt
            TBCCTL2 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL3 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            }
        break;
// 8824 Microstepping Sine Wave Generator [ OPCODE = 0x50 ] [ FREQ HI ] [ FREQ LO ] [ ENABLE / DISABLE ] [ Not Used ]
case (MICRO_STEP_8824):
            TBCCTL5 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            Frequency[5] = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            TBCCR5 = Frequency[5];
            MS_Index = 0;
            if (SerialBuffer[3])
            {
            TBCCTL5 |= CCIE;                                            //Configure the timer to interrupt
            }
            else
            {
            TBCCTL5 &= ~CCIE;                                            //Disable the Timer Interrupt
            }
        break;
// Read Memory [Opcode = 0xE0 ] [ Address Hi ] [ Address Lo ] [ Not Used ] [ Not Used ]
      case (READ_MEM):
       int * MyPointer;
       int Address;

       Address = (SerialBuffer[1]*256 + SerialBuffer[2]);
       MyPointer = (int *) Address;
       SerialOutBuffer[1] = (*MyPointer & 0xFF00) >> 8;
       SerialOutBuffer[2] = (*MyPointer & 0xFF);
      break;
// Write Memory [Opcode = 0xE1 ] [ Address Hi ] [ Address Lo ] [ Data Hi ] [ Data Lo ]
      case (WRITE_WMEM):
        int Data;

        Address = (SerialBuffer[1]*256 + SerialBuffer[2]);
        Data = (SerialBuffer[3]*256 + SerialBuffer[4]);
        MyPointer = (int *) Address;
        *MyPointer = Data;
        break;

// Write Byte Memory [Opcode = 0xE2 ] [ Address ] [ Address Lo ] [ Data ] [Not Used ]
      case (WRITE_BMEM):
        char BData;
        char * MyPtr;

        Address = (SerialBuffer[1]*256 + SerialBuffer[2]);
        BData = SerialBuffer[3];
        MyPtr = (char *) Address;
        *MyPtr = BData;
        break;

      case (GET_FW_REV):
        SerialOutBuffer[0] = (unsigned char)FIRMWARE_RELEASE_3;
        SerialOutBuffer[1] = (unsigned char)FIRMWARE_RELEASE_2;
        SerialOutBuffer[2] = (unsigned char)FIRMWARE_RELEASE_1;
        break;
      case (RESET_MCU):
        WDTCTL = 0x00;
        break;
      case (SHOW_CLKS):
        P5SEL |= SerialBuffer[1] & 0xF0;
        break;
      }
    MessageComplete = false;
    SerialOutPointer = 0;
    TXBUF0 = SerialOutBuffer[SerialOutPointer];
    IE1 |= UTXIE0;
    }
}





