#include <msp430G2432.h>
#include "magnet.h"
#include "com.h"

extern unsigned char mclk_flag;
unsigned int bit_0_t = 0;
unsigned int bit_1_t = 0;
unsigned int BIT_0_POS = 0;
unsigned int BIT_0_NEG = 0;
unsigned int BIT_1_POS = 0;
unsigned int BIT_1_NEG = 0;
unsigned long read_card_time_out = 0;
unsigned long cmd_detect_time_out = 0;

extern unsigned char mclk_freq_flag;
extern unsigned char smclk_freq_flag;

#define BIT_JITTER 2


extern unsigned char adc_mode;

unsigned int L_CH_baseline = 0;

void com_init_adc(void);
static void com_init1(void);
void com_sendAck(unsigned char cmd, unsigned char len, unsigned char *buf) {
	com_init1();
	com_sendIdle(60);
	com_sendCommand(cmd);
	com_sendLength(len);
	com_sendData(buf, len);
	com_sendIdle(10);

}

void com_sendAck2(unsigned char cmd, unsigned char len1, unsigned char *buf1,
		unsigned char len2, unsigned char *buf2) {
//	unsigned char c=0xff;
	com_init1();
	com_sendIdle(60);
	com_sendCommand(cmd);
	com_sendLength(len1);
	com_sendData(buf1, len1);
	com_sendLength(len2);
	com_sendData(buf2, len2);

//	com_sendData(&c,1);
	com_sendIdle(8);

}

//init time constant
//init gpio
void com_init(void) {

	//MCLK and SMCLK in this demo is fixed to 4.25Mhz
	bit_0_t = 454 / 2 * 4 * 1;
	bit_1_t = 909 / 2 * 4 * 1;

	BIT_0_POS = bit_0_t + (bit_0_t >> BIT_JITTER);
	BIT_0_NEG = bit_0_t - (bit_0_t >> BIT_JITTER);
	BIT_1_POS = bit_1_t + (bit_1_t >> BIT_JITTER);
	BIT_1_NEG = bit_1_t - (bit_1_t >> BIT_JITTER);

	read_card_time_out = 60000000;
	cmd_detect_time_out = 12500;

}

//initialize IO and ADC every time before send ack
static void com_init1(void) {

	//P1.2 used for data output
	P1DIR |= BIT7;
	P1OUT &= ~BIT7;
	//start timer and clear timer int flag
	TA0CTL = TASSEL_2 + MC_2;

}

//send series of idle bit (which is "0")
//bit_len: 100 bits max
void com_sendIdle(unsigned int bit_len) {
	unsigned char i;

	for (i = 0; i < bit_len; i++) {
		com_send_0();

	}

}

//assume we are using TimerA0 @4Mhz clock
//Timer must be enabled in advance
//
static void com_sendBit(unsigned int time) {
	TA0R = 0;

	//p1.4 for Microphone output
	//output high
	P1OUT |= BIT7;

	//wait Timer equal to time
	while (TA0R < time)
		;

	TA0R = 0;
	P1OUT &= ~BIT7;
	while (TA0R < time)
		;

}

//"0" takes 454us, half is 227us
//when timer runs @4Mhz, it is 227*4 clock cycle
static void com_send_0(void) {
	com_sendBit(bit_0_t);

}
//"1" takes 909us, half is 454us
//when timer runs @4Mhz, it is 454*4 clock cycle
static void com_send_1(void) {
	com_sendBit(bit_1_t);

}

//send out length byte of ACK frame
//MSB first
static void com_sendLength(unsigned char len) {
	unsigned int i = 0;

	for (i = 0; i < 8; i++) {
		if ((len & 0x80) != 0) {
			com_send_1();
		} else {
			com_send_0();
		}
		len = len << 1;

	}

}

//send out command byte of ACK frame
//MSB first
static void com_sendCommand(unsigned char cmd) {
	unsigned int i = 0;

	for (i = 0; i < 8; i++) {
		if ((cmd & 0x80) != 0) {
			com_send_1();
		} else {
			com_send_0();
		}
		cmd = cmd << 1;

	}

}

//send out data in buffer
//len: the nibble count of the buffer
// one byte contains two nibble: high nibble is N+1 character, low nibble is N character
//Send lower nibble first
//MSB send first for every character/nibble
static void com_sendData(unsigned char *buf, unsigned char len) {
	unsigned char *ptr;
	unsigned char nibble_lo, nibble_hi = 0;
	unsigned char i = 0;

	if (len <= 0)
		return;

	ptr = buf;

	while (1) {
		nibble_lo = (*ptr) & 0x0f;
		nibble_hi = (*ptr) & 0xf0;
		nibble_hi = nibble_hi >> 4;

		//lower nibble
		for (i = 0; i < 4; i++) {
			if ((nibble_lo & 0x8) != 0) {
				com_send_1();
			} else {
				com_send_0();
			}
			nibble_lo = nibble_lo << 1;

		}

		len -= 1;
		if (len <= 0)
			break;

		//lower nibble
		for (i = 0; i < 4; i++) {
			if ((nibble_hi & 0x8) != 0) {
				com_send_1();
			} else {
				com_send_0();
			}
			nibble_hi = nibble_hi << 1;

		}
		len -= 1;
		if (len <= 0)
			break;
		ptr++;

	}

}

