%#############################################################################
% $TI Release: TIDA_01606_T_Type_DC_Bus_Voltage_Ver1.0 $
% $Release Date: Sep 28 2022 $
% $Copyright:
% Copyright (C) 2022 Texas Instruments Incorporated - http://www.ti.com/
%
% ALL RIGHTS RESERVED
%Description: file used for setting all the required parameters of the model.
%Before running the matlab simulation the parameter file must be executed.
%%#############################################################################

clear all
close all
clc


fsw=50e3;
Vdc=800; 
dead_time=200e-9;
%Grid parameters
Vline=230;
Vline_peak=Vline*sqrt(2);
fe=50; %Electrical frequency
Vd_Grid= sqrt(3)/sqrt(2)*Vline*sqrt(2);

Power=-11e3*0.98*0.99;
Idc=Power/Vdc;
Iq=0;


%Filtering parameters
L_line=340e-6;
Cfn1=10e-6;
Cfn2=4.7e-6;
L_out=6e-6;
Rfn=0.005;
Lcommon=3.4e-3;
Cfdck_mid_point=0.47e-6;
Cflyingcap=6e-6;
Cbus_middle=470e-6;
Cbus=300e-6;


%Current control bandwidth
fband=2000;
Omegaband=fband*2*pi;
Kp=Omegaband*L_line;
Ki=Kp*Omegaband*0.1;

%Voltage control bandwidth
fband_voltage=400;
Omegaband_voltage=fband_voltage*2*pi;
Kp_voltage=Omegaband_voltage*Cbus*Vdc/Vd_Grid;
Ki_voltage=Kp_voltage*Omegaband_voltage*0.2;


%Parameter of the switch
Rdon=80e-3;
Vf_ON_Diode=3;
Rdon_Diode=50e-3;





















