************************************************************************
************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized   *
*          reproduction and/or distribution is strictly prohibited.    *
*                                                                      *
*          This product is protected under copyright law.              *
*          Created 1998, (C) Copyright 1998, Texas Instruments Inc.,   *
*          All Rights Reserved                                         *
*                                                                      *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE          *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE   *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR       *
*          IMPLIED.  TI assumes no liability for:                      *
*          1) the accuracy of the SPICE models provided to your        *
*             company;                                                 *
*          2) the proper functioning of these SPICE models in your     *
*             design or for any resulting applications; or             *
*          3) infringement of patents, copyrights or intellectual      *
*             property rights resulting from your use of these         *
*             SPICE models.                                            *
*                                                                      *
*          TI provides SPICE Models as a service to our customers.     *
*          You and your company shall not distribute, sell or give     *
*          these models to anyone else without prior written           *
*          permission from TI.                                         *
*                                                                      *
*          TI reserves the right to make changes to our products or    *
*          to discontinue any semiconductor product or service         *
*          without notice, and advises our customers to obtain the     *
*          latest version of relevant information to verify, before    *
*          placing orders, that the information being relied on is     *
*          current.                                                    *
*                                                                      *
*          Please be aware that your receipt and use of the SPICE      *
*          information provided shall serve as acceptance of these     *
*          terms and conditions.  If you do not accept these terms,    *
*          you should return or destroy the SPICE models and any       *
*          other accompanying information immediately.                 *
************************************************************************
*
* HSPICE Deck for CBTLV16292 
* SLL APPLICATIONS
* DATE : February 2000 
*
************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-15     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-15
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
***********************************************************************
***********************************************************************

      
        .OPTIONS search='./'
	 
         X_DEVICE_SELECTOR  0 CBTLV16292INC    $ENCRYPTED DEVICE NETLIST

***PLEASE INCLUDE ANYONE OF THE PROCESS MODEL

**ENCRYPTED LEVEL 49 PROCESS MODEL 
         X_PROCESS_SELECTOR 0 ASL3CN49INC      $NOMINAL PROCESS MODEL   
*         X_PROCESS_SELECTOR 0 ASL3CS49INC      $STRONG  PROCESS MODEL 
*        X_PROCESS_SELECTOR 0 ASL3CW49INC      $WEAK    PROCESS MODEL 


***PKG  FILE***
.INCLUDE  'TSSOP56.PKG' 
*.INCLUDE  'SSOP56.PKG
*

*REFER TO DATASHEET FOR NODE DESCRIPTION***
**read.me for general instructions**


***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
*
xCBTLV16292  s a1 b1 b2 vcc gnd CBTLV16292  
*
***********************************************************************
******Supply Voltages
***********************************************************************
vvcc       vcc      0    DC    3.3 
vgnd       gnd      0    DC    0.0

*
*
***********************************************************************
******Subcircuit for package connection
***********************************************************************
*
.SUBCKT CBTLV16292 p_sel p_a1  p_b1 p_b2 p_vcc p_gnd 
 
 X_PIN1	       p_sel           s_sel    TSSOP56_01
 X_PIN2        p_a1            s_a1     TSSOP56_02  		
 X_PIN53       p_b2            s_b2 	TSSOP56_53	
 X_PIN54       p_b1 	       s_b1 	TSSOP56_54  	
 X_PIN8        p_gnd           s_gnd    TSSOP56_08 	
 X_PIN17       p_vcc           s_vcc    TSSOP56_17        
 XCBTLV16292bit s_sel s_a1 s_b1  s_b2 s_vcc s_gnd CBTLV16292_bit
.ENDS CBTLV16292 
*
***********************************************************************
***********************************************************************
.temp 25
.param capload=50p
.param resload=500
.param biashv=3
.param biaslv=0.0
.param supplyv=3.3
.param loadv=6
*
**** TRANSIENT ANALYSES <-------
*
    .TRAN       0.1NS      60NS
         
    
    V_a1        x_a1  0    PULSE (biaslv supplyv 5ns 1ns 1ns 20ns 40ns) 
    R_x_a1      x_a1  a1   10

**SELECTION INPUT HIGH  A --> B2
    V_sel        s       0          dc  3.3 


    Rb1_LOAD    b1       0          resload
    Cb1_LOAD    b1       0          capload
    Rb2_LOAD    b2       0          resload
    Cb2_LOAD    b2       0          capload

*
***********************************************************************
.END
*                                         




