******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for SN74CBTLV3126
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2006, (C) COPYRIGHT 2006, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
* .INCLUDE 'sn74cbtlv3126.inc'
X__SN74CBTLV3126 X_1OE X_1A X_1B X_2OE X_2A X_2B GND X_3B X_3A X_3OE X_4B
+ X_4A X_4OE VCC SN74CBTLV3126
*** PULSE PARAMETERS ***
.param PDELAY1=5ns $ delay of 1st pulse
.param PVIN='PVCC' $ input voltage

*** TRANSIENT START & START PARAMETERS ***
.param PSTART='PDELAY1' $ time input starts to transition.
.param PSTOP='PSTART+20n' $
.TRAN 0.05n 'PSTOP' 'PSTART' 0.05n
.PRINT TRAN v(DATA)

* SET CONTROL INPUTS TO ENABLE OUTPUT
VC0 X_1OE 0 DC 'PVCC'


*** SET INPUT AND TEST OUTPUT TO GO LOW ****
VP0 X_1B GND PULSE 0 'PVCC' 5ns 2ns 2ns 8ns 20ns

* CHANGE TO THE OUTPUT NODE
VDATA X_1A DATA DC 0
RLOAD DATA GND 500

* VOLTAGE SUPPLIES
VGND1 GND1 GND DC 0
RDUMMY GND1 GND 10M

.param PVCC=3.3
.param PGND=0v
VVCC VCC 0 'PVCC'
VGND GND 0 'PGND'

.TEMP 40

* RESISTORS TO PREVENT DANGLING NODES
* R1G_1 X_1OE 0 1G
* R1G_2 X_1A 0 1G
* R1G_3 X_1B 0 1G
R1G_4 X_2OE 0 1G
R1G_5 X_2A 0 1G
R1G_6 X_2B 0 1G
* R1G_7 GND 0 1G
R1G_8 X_3B 0 1G
R1G_9 X_3A 0 1G
R1G_10 X_3OE 0 1G
R1G_11 X_4B 0 1G
R1G_12 X_4A 0 1G
R1G_13 X_4OE 0 1G
* R1G_14 VCC 0 1G

.END
