******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for TS3DV416
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2004, (C) COPYRIGHT 2004, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
.INCLUDE 'ts3dv416.inc'
X__TS3DV416 VCC A1 GND A2 GND VCC GND A3 GND A4 GND VCC GND NC A5 GND A6
+ GND VCC GND A7 GND A8 SEL X_8B2 X_7B2 GND X_8B1 X_7B1 GND X_6B2 X_5B2 GND
+ X_6B1 X_5B1 VCC GND X_4B2 X_3B2 GND X_4B1 X_3B1 GND X_2B2 X_1B2 GND X_2B1
+ X_1B1 TS3DV416

*** PULSE PARAMETERS ***
.param PFREQ1=10MEG $ 1st pulse (clk) frequency
.param PRFT19=2ns $ rise/fall time
.param PDELAY1=5ns $ delay of 1st pulse
.param PVIN='PVCC' $ input voltage
.param PVT=1.7 $ input threshold voltage
.param PMAX=2ns $ max SPICE delay time
.param PRFT='(PRFT19/0.8)' $ convert rise/fall time to 100$
.param PPD1='(1/PFREQ1)' $ period of 1st pulse
.param PPW1='((PPD1 - (PRFT*2))/2)' $ pulse width of 1st pulse

*** TRANSIENT START & START PARAMETERS ***
.param PSTART='PDELAY1' $ time input starts to transition.
.param PSTOP='PSTART+40n' $
.TRAN 0.05n 'PSTOP' 'PSTART' 0.05n
.PRINT TRAN v(x_1b2) v(x_1b1)

* SET CONTROL INPUTS TO ENABLE OUTPUT

*** SET INPUT AND TEST OUTPUT TO GO LOW ****
VI0 A1 0 pulse 0 'PVIN' 'PDELAY1' 'PRFT' 'PRFT' 8n 20n
VC1 SEL 0 pulse 0 'PVIN' 'PDELAY1' 'PRFT' 'PRFT' 18n 40n

* CHANGE TO THE OUTPUT NODE
RLOAD  X_1B1 0 500
RLOAD2 X_1B2 0 500

* VOLTAGE SUPPLIES
.param PVCC=3.3
.param PGND=0v
VGND GND 0 'PGND'
VVCC VCC 0 'PVCC'

.TEMP 40

* RESISTORS TO PREVENT DANGLING NODES
R1G_1 VCC 0 1G
R1G_2 A1 0 1G
R1G_3 GND 0 1G
R1G_4 A2 0 1G
R1G_5 GND 0 1G
R1G_6 VCC 0 1G
R1G_7 GND 0 1G
R1G_8 A3 0 1G
R1G_9 GND 0 1G
R1G_10 A4 0 1G
R1G_11 GND 0 1G
R1G_12 VCC 0 1G
R1G_13 GND 0 1G
R1G_14 NC 0 1G
R1G_15 A5 0 1G
R1G_16 GND 0 1G
R1G_17 A6 0 1G
R1G_18 GND 0 1G
R1G_19 VCC 0 1G
R1G_20 GND 0 1G
R1G_21 A7 0 1G
R1G_22 GND 0 1G
R1G_23 A8 0 1G
R1G_24 SEL 0 1G
R1G_25 X_8B2 0 1G
R1G_26 X_7B2 0 1G
R1G_27 GND 0 1G
R1G_28 X_8B1 0 1G
R1G_29 X_7B1 0 1G
R1G_30 GND 0 1G
R1G_31 X_6B2 0 1G
R1G_32 X_5B2 0 1G
R1G_33 GND 0 1G
R1G_34 X_6B1 0 1G
R1G_35 X_5B1 0 1G
R1G_36 VCC 0 1G
R1G_37 GND 0 1G
R1G_38 X_4B2 0 1G
R1G_39 X_3B2 0 1G
R1G_40 GND 0 1G
R1G_41 X_4B1 0 1G
R1G_42 X_3B1 0 1G
R1G_43 GND 0 1G
R1G_44 X_2B2 0 1G
R1G_45 X_1B2 0 1G
R1G_46 GND 0 1G
R1G_47 X_2B1 0 1G
R1G_48 X_1B1 0 1G

.END
