*****************************************************************************
* (C) Copyright 2011 Texas Instruments Incorporated. All rights reserved.
*****************************************************************************
** This model is designed as an aid for customers of Texas Instruments.
** TI and its licensors and suppliers makeno warranties, either expressed
** or implied, with respect to thismodel, including the warranties of
** merchantability or fitness fora particular purpose. The model is
** provided solely on an "as is" basis. The entirerisk as to its quality
** and performance is with the customer.
*****************************************************************************
*
* Released by: Analog eLab Design Center, Texas Instruments Inc.
* Part:        TS3A26746E
*              2x2 Cross-Point Switch for Audio Applications
* Date:        2011-07-22
* Model Type:  HSPICE
* Simulator:   HSPICE E-2010.12-SP1 in Windows7
* Datasheet:   SCDS313 - FERUARY 2010 - REVISED MAY 2011
*
*****************************************************************************
* Model version 1.0:
*****************************************************************************
* Notes:
* The netlist and parameters below are the equivalent condition to that 
* shown in the data sheet Figure 1-Standard Headphone Configuration (SEL=H).
* The signal path is from sleeve -> mic and ring2 is gnd.
* 
* If the parameter sel changed from HIGH to LOW, the test condition becomes
* equivalent to that shown in the data sheet Figure 2 Alternate Headphone
* Configuration (SEL=L).The signal path is from ring2 -> mic and sleeve is gnd. 
****************************************************************************

.PARAM VDD=3.3
.PARAM SEL=3.3
.PARAM f=20e3

.PROBE TRAN
+ MIC
+ SLEEVE
+ RING2

.TRAN 100e-9 100e-6 START=0.0

.OP

.TEMP 25

.OPTIONS ACCT ACCURATE NOPAGE OPTS POST SCALE=1e-6
.OPTIONS METHOD=GEAR

.INCLUDE "TS3A26746E_process_windows.lib"
.INCLUDE "TS3A26746E_subckt_windows.sp"

xi38 SEL MIC SLEEVE 0 RING2 VDD TS3A26746E
r0 MIC_BIAS MIC 2.2e3

* ---- Test signal input w/dependence on SEL = LOW/HIGH -----
* The line just below is for the condition SEL = HIGH       |
* set in the .PARAM statement above.
* This condition corresponds to Figure 1 in the data sheet. |
v1 SLEEVE RING2  SIN 1.6 15e-3 f

* For the condition SEL = LOW (set in .PARAM statement above) 
* uncomment the v1 line below and comment/remove            |
* the v1 line above.                                        |
* This condition corresponds to Figure 2 in the data sheet. |
* v1 RING2 SLEEVE  SIN 1.6 15e-3 f                            |
* ----------------------------------------------------------

v3 VDD    0  DC=VDD
v2 SEL    0  DC=SEL
v5 MIC_BIAS 0  DC=2.7
.END