************************************************************************
*Standard Linear and Logic, Texas Instruments
************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized   *
*          reproduction and/or distribution is strictly prohibited.    *
*                                                                      *
*          This product is protected under copyright law.              *
*          Created 1998, (C) Copyright 1998, Texas Instruments Inc.,   *
*          All Rights Reserved                                         *
*                                                                      *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE          *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE   *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR       *
*          IMPLIED.  TI assumes no liability for:                      *
*          1) the accuracy of the SPICE models provided to your        *
*             company;                                                 *
*          2) the proper functioning of these SPICE models in your     *
*             design or for any resulting applications; or             *
*          3) infringement of patents, copyrights or intellectual      *
*             property rights resulting from your use of these         *
*             SPICE models.                                            *
*                                                                      *
*          TI provides SPICE Models as a service to our customers.     *
*          You and your company shall not distribute, sell or give     *
*          these models to anyone else without prior written           *
*          permission from TI.                                         *
*                                                                      *
*          TI reserves the right to make changes to our products or    *
*          to discontinue any semiconductor product or service         *
*          without notice, and advises our customers to obtain the     *
*          latest version of relevant information to verify, before    *
*          placing orders, that the information being relied on is     *
*          current.                                                    *
*                                                                      *
*          Please be aware that your receipt and use of the SPICE      *
*          information provided shall serve as acceptance of these     *
*          terms and conditions.  If you do not accept these terms,    *
*          you should return or destroy the SPICE models and any       *
*          other accompanying information immediately.                 *
************************************************************************
* SLL APPLICATIONS
* DATE : January, 2001
*NOTE:
*This is the user's file.Refer to the read.me file before you proceed.
*
************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-10     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-10
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
*
***********************************************************************
*
*   NOTE:
*   The following files must be present to use this SPICE model:
*      SSTV16859INC.INC     (netlist)
*      p25c21aninc.inc     (Nominal process models)
*      p25c21asinc.inc     (Strong  process models) 	
*      p25c21awinc.inc     (Weak    process models)
*      READ.ME            (General use, release notes, ...)
*
*   INSTRUCTIONS:
*   For the process model use either the strong (p25c21asINC)
*				     the weak   (p25c21awINC)
*				     the nominal(p25c21anINC) 	 	
*   To use this SPICE model, include the following lines in your main netlist:
*      (Choose only one package model and one process model)
*      .
*      .
*      .
*       .OPTIONS search='./'
        X_DEVICE_SELECTOR  0 SSTV16859INC
	X_PROCESS_SELECTOR 0 p25c21anINC
*	X_PROCESS_SELECTOR 0 p25c21asINC
*	X_PROCESS_SELECTOR 0 p25c21awINC
	.include tssop64
***********************************************************************
* Refer to the data sheet for node description.
***********************************************************************
******Top level Subcircuit call (user's nodes)
***********************************************************************
xsstv16859 x_q1a x_q1b x_d1 x_vref x_clk x_clk_ x_reset_ x_VDDQ x_CVCC x_CGND sstv16859

***********************************************************************
******Supply Voltages
***********************************************************************
v_gnd	x_CGND	0	DC	0.00
v_vcc	x_CVCC	0	DC	2.70
v_vddq	x_VDDQ	0	DC	2.50
v_vref	x_vref	0	DC	1.25
v_vtt	x_vtt	0	DC	1.25

***********************************************************************
******Subcircuit for package connection
***********************************************************************
.SUBCKT sstv16859 p_q1a p_q1b p_d1 p_vref p_clk p_clk_ p_reset_ p_VDDQ p_CVCC p_CGND
 X_PIN16	p_q1a		s_q1a		tssop64_16
 X_PIN32	p_q1b		s_q1b		tssop64_32
 X_PIN35	p_d1		s_d1		tssop64_35
 X_PIN45	p_vref		s_vref		tssop64_45
 X_PIN48	p_clk		s_clk		tssop64_48
 X_PIN49	p_clk_		s_clk_		tssop64_49
 X_PIN51	p_reset_	s_reset_	tssop64_51
 X_PIN6		p_VDDQ		s_VDDQ		tssop64_06
 X_PIN18	p_VDDQ		s_VDDQ		tssop64_18
 X_PIN27	p_VDDQ		s_VDDQ		tssop64_27
 X_PIN33	p_VDDQ		s_VDDQ		tssop64_33
 X_PIN38	p_VDDQ		s_VDDQ		tssop64_38
 X_PIN47	p_VDDQ		s_VDDQ		tssop64_47
 X_PIN59	p_VDDQ		s_VDDQ		tssop64_59
 X_PIN64	p_VDDQ		s_VDDQ		tssop64_64
 X_PIN37	p_CVCC		s_CVCC		tssop64_37
 X_PIN60	p_CVCC		s_CVCC		tssop64_60
 X_PIN7		p_CGND		s_CGND		tssop64_07
 X_PIN15	p_CGND		s_CGND		tssop64_15
 X_PIN26	p_CGND		s_CGND		tssop64_26
 X_PIN34	p_CGND		s_CGND		tssop64_34
 X_PIN39	p_CGND		s_CGND		tssop64_39
 X_PIN43	p_CGND		s_CGND		tssop64_43
 X_PIN50	p_CGND		s_CGND		tssop64_50
 X_PIN54	p_CGND		s_CGND		tssop64_54
 X_PIN58	p_CGND		s_CGND		tssop64_58
 X_PIN63	p_CGND		s_CGND		tssop64_63
xsstv16859 s_q1a s_q1b s_d1 s_vref s_clk s_clk_ s_reset_ s_VDDQ s_CVCC s_CGND sstv16859_bit
.ENDs sstv16859

***********************************************************************

.END
