************************************************************************
*Standard Linear and Logic, Texas Instruments
************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized   *
*          reproduction and/or distribution is strictly prohibited.    *
*                                                                      *
*          This product is protected under copyright law.              *
*          Created 1998, (C) Copyright 1998, Texas Instruments Inc.,   *
*          All Rights Reserved                                         *
*                                                                      *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE          *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE   *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR       *
*          IMPLIED.  TI assumes no liability for:                      *
*          1) the accuracy of the SPICE models provided to your        *
*             company;                                                 *
*          2) the proper functioning of these SPICE models in your     *
*             design or for any resulting applications; or             *
*          3) infringement of patents, copyrights or intellectual      *
*             property rights resulting from your use of these         *
*             SPICE models.                                            *
*                                                                      *
*          TI provides SPICE Models as a service to our customers.     *
*          You and your company shall not distribute, sell or give     *
*          these models to anyone else without prior written           *
*          permission from TI.                                         *
*                                                                      *
*          TI reserves the right to make changes to our products or    *
*          to discontinue any semiconductor product or service         *
*          without notice, and advises our customers to obtain the     *
*          latest version of relevant information to verify, before    *
*          placing orders, that the information being relied on is     *
*          current.                                                    *
*                                                                      *
*          Please be aware that your receipt and use of the SPICE      *
*          information provided shall serve as acceptance of these     *
*          terms and conditions.  If you do not accept these terms,    *
*          you should return or destroy the SPICE models and any       *
*          other accompanying information immediately.                 *
************************************************************************
* SLL APPLICATIONS
* DATE : January, 2002
*NOTE:
*This is the user's file.Refer to the read.me file before you proceed.
*
************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-10     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-10
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
*
***********************************************************************
*
*   NOTE:
*   The following files must be present to use this SPICE model:
*      AUC1G07INC.INC     (netlist)
*      p25c21aninc.inc     (Nominal process models)
*      p25c21asinc.inc     (Strong  process models) 	
*      p25c21awinc.inc     (Weak    process models)
*      READ.ME            (General use, release notes, ...)
*
*   INSTRUCTIONS:
*   For the process model use either the strong (p25c21asINC)
*				     the weak   (p25c21awINC)
*				     the nominal(p25c21anINC) 	 	
*   To use this SPICE model, include the following lines in your main netlist:
*      (Choose only one package model and one process model)
*      .
*      .
*      .
*
*       .OPTIONS search='./'
        X_DEVICE_SELECTOR  0 AUC1G07INC
	X_PROCESS_SELECTOR 0 p25c21anINC
*	X_PROCESS_SELECTOR 0 p25c21asINC
*	X_PROCESS_SELECTOR 0 p25c21awINC
	.include resistor_modn
*	.include resistor_mods
*	.include resistor_modw
	.include sot5
***********************************************************************
* Refer to the data sheet for node description.
***********************************************************************
******Top level Subcircuit call (user's nodes)
***********************************************************************
xauc1g07 x_a x_y x_CVCC x_CGND auc1g07

***********************************************************************
******Supply Voltages
***********************************************************************
v_gnd	x_CGND	0	DC	biaslv
v_vcc	x_CVCC	0	DC	biashv
v_2vcc	x_2VCC	0	DC	'2*biashv'

***********************************************************************
******Subcircuit for package connection
***********************************************************************
.SUBCKT auc1g07 p_a p_y p_CVCC p_CGND
 X_PIN2		p_a		s_a		sot5_02
 X_PIN4		p_y		s_y		sot5_04
 X_PIN5		p_CVCC		s_CVCC		sot5_05
 X_PIN3		p_CGND		s_CGND		sot5_03
xauc1g07 s_a s_y s_CVCC s_CGND auc1g07__bit
.ENDs auc1g07

***********************************************************************
.temp 25
.param er=1ns			$signal generator output edge rate
.param freq=50xHz		$signal generator frequency x=Meg
.param perc='1/freq'		$period of clock generator output cycle
.param pwc='(perc/2)-er'	$width of clock high and low level portion of cycle
.param perd='2*perc'		$period of clock generator output cycle
.param pwd='(perd/2)-er'	$width of clock high and low level portion of cycle


.param rt=500
.param cl=30p

.param biaslv=0.0
.param biashv=2.5

***********************************************************************
**** TRANSIENT ANALYSES <-------
**** Propagation test (LH/HL)
***********************************************************************
.TRAN         0.05NS 200NS

V_a		x_a		0	PULSE	(biaslv biashv '(3*perc)-er' er er pwd perd)

C_load		x_y	0	cl
R_load1		x_y	0	rt
R_load2		x_y	x_2VCC	rt


***********************************************************************
.END
