******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for SN74AVC16374
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2004, (C) COPYRIGHT 2004, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
****************************************************************************
.OPTIONS search='./'

*** DATA PULSE PARAMETERS **************************************************
.param DT_PFREQ=5MEG $ 1st pulse frequency
.param DT_PDELAY=20ns $ delay of 1st pulse
.param DT_PRFT=1ns $rise and fall time
.param DT_PPD='(1/DT_PFREQ)' $ period of 1st pulse
.param DT_PPW='((DT_PPD - (DT_PRFT*2))/2)' $ pulse width of 1st pulse

*** CLOCK PULSE PARAMETERS *************************************************
.param CK_PFREQ=10MEG $ 1st pulse (clk) frequency
.param CK_PDELAY=5ns $ delay of 1st pulse
.param CK_PRFT=1ns $rise and fall time
.param CK_PPD='(1/CK_PFREQ)' $ period of 1st pulse
.param CK_PPW='((CK_PPD - (CK_PRFT*2))/2)' $ pulse width of 1st pulse


***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
.INCLUDE 'sn74avc16374.inc'
X__SN74AVC16374 X_1NOE X_1Q1 X_1Q2 X_GND X_1Q3 X_1Q4 X_VCC X_1Q5 X_1Q6 X_GND
+ X_1Q7 X_1Q8 X_2Q1 X_2Q2 X_GND X_2Q3 X_2Q4 X_VCC X_2Q5 X_2Q6 X_GND X_2Q7 X_2Q8
+ X_2NOE X_2CLK X_2D8 X_2D7 X_GND X_2D6 X_2D5 X_VCC X_2D4 X_2D3 X_GND X_2D2
+ X_2D1 X_1D8 X_1D7 X_GND X_1D6 X_1D5 X_VCC X_1D4 X_1D3 X_GND X_1D2 X_1D1
+ X_1CLK SN74AVC16374

**********************
*******SUPPLY VOLTAGES
**********************
VVCC  X_VCC  0 DC 5
VCGND X_GND  0 DC 0

********************
**********SIMULATION
********************
.TRAN 1NS 500NS

*********************
*********CONTROL PINS
*********************
V1NOE X_1NOE 0 DC 0
V2NOE X_2NOE 0 DC 0
V2CLK X_2CLK 0 DC 0

********************
********TEST SIGNALS
********************
V1D1   X_1D1  0 PULSE (0 5 DT_PDELAY DT_PRFT DT_PRFT DT_PPW DT_PPD) 
V1CLK  X_1CLK 0 PULSE (0 5 CK_PDELAY CK_PRFT CK_PRFT CK_PPW CK_PPD)
R1Q1   X_1Q1  X_VCC 2000
C1Q1   X_1Q1  0 15p

* RESISTORS TO PREVENT DANGLING NODES
R1G_1 X_1NOE 0 1G
R1G_2 X_1Q1 0 1G
R1G_3 X_1Q2 0 1G
R1G_4 X_GND 0 1G
R1G_5 X_1Q3 0 1G
R1G_6 X_1Q4 0 1G
R1G_7 X_VCC 0 1G
R1G_8 X_1Q5 0 1G
R1G_9 X_1Q6 0 1G
R1G_10 X_GND 0 1G
R1G_11 X_1Q7 0 1G
R1G_12 X_1Q8 0 1G
R1G_13 X_2Q1 0 1G
R1G_14 X_2Q2 0 1G
R1G_15 X_GND 0 1G
R1G_16 X_2Q3 0 1G
R1G_17 X_2Q4 0 1G
R1G_18 X_VCC 0 1G
R1G_19 X_2Q5 0 1G
R1G_20 X_2Q6 0 1G
R1G_21 X_GND 0 1G
R1G_22 X_2Q7 0 1G
R1G_23 X_2Q8 0 1G
R1G_24 X_2NOE 0 1G
R1G_25 X_2CLK 0 1G
R1G_26 X_2D8 0 1G
R1G_27 X_2D7 0 1G
R1G_28 X_GND 0 1G
R1G_29 X_2D6 0 1G
R1G_30 X_2D5 0 1G
R1G_31 X_VCC 0 1G
R1G_32 X_2D4 0 1G
R1G_33 X_2D3 0 1G
R1G_34 X_GND 0 1G
R1G_35 X_2D2 0 1G
R1G_36 X_2D1 0 1G
R1G_37 X_1D8 0 1G
R1G_38 X_1D7 0 1G
R1G_39 X_GND 0 1G
R1G_40 X_1D6 0 1G
R1G_41 X_1D5 0 1G
R1G_42 X_VCC 0 1G
R1G_43 X_1D4 0 1G
R1G_44 X_1D3 0 1G
R1G_45 X_GND 0 1G
R1G_46 X_1D2 0 1G
R1G_47 X_1D1 0 1G
R1G_48 X_1CLK 0 1G

.END
