******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for SN74LV221A
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2007, (C) COPYRIGHT 2007, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
* .INCLUDE 'sn74lv221a.inc'
X__SN74LV221A NA1 B1 NCLR1 NQ1 Q2 CX2 RX_CX2 GND NA2 B2 NCLR2 NQ2 Q1 CX1
+ RX_CX1 VCC SN74LV221A
*** PULSE PARAMETERS ***
.param PFREQ1=10MEG $ 1st pulse (clk) frequency
.param PRFT19=2ns $ rise/fall time
.param PDELAY1=5ns $ delay of 1st pulse
.param PVIN='PVCC' $ input voltage
.param PVT='PVCC/2' $ input threshold voltage
.param PMAX=20NS $ max SPICE delay time
.param PRFT='(PRFT19/0.8)' $ convert rise/fall time to 100$
.param PPD1='(1/PFREQ1)' $ period of 1st pulse
.param PPW1='((PPD1 - (PRFT*2))/2)' $ pulse width of 1st pulse

*** TRANSIENT START & START PARAMETERS ***
.param PSTART='PDELAY1' $ time input starts to transition.
.param PSTOP='PSTART+160n' $
.TRAN 0.05n 'PSTOP' 'PSTART' 0.05n
.PRINT TRAN v(DATA)

* SET CONTROL INPUTS TO ENABLE OUTPUT



*** SET INPUT AND TEST OUTPUT TO GO LOW ****
VI0 NA1 0 pulse 'PVIN' 0 'PDELAY1' 'PRFT' 'PRFT' 18ns 40ns
VI1 B1 0 pulse 'PVIN' 0 'PDELAY1' 'PRFT' 'PRFT' 38ns 80ns
VI2 NCLR1 0 pulse 'PVIN' 0 'PDELAY1' 'PRFT' 'PRFT' 78ns 160ns

* CHANGE TO THE OUTPUT NODE
VDATA Q1 DATA DC 0
CLOAD DATA 0 50pF

* VOLTAGE SUPPLIES

.param PVCC=5
.param PGND=0v
VVCC VCC 0 'PVCC'
VGND GND 0 'PGND'

.TEMP 40

RT1  VCC    RX_CX1  2k
CT1  RX_CX1 CX1     28pF
VCX1 CX1    GND     DC 0V

* RESISTORS TO PREVENT DANGLING NODES
* R1G_1 NA1 0 1G
* R1G_2 B1 0 1G
* R1G_3 NCLR1 0 1G
R1G_4 NQ1 0 1G
R1G_5 Q2 0 1G
R1G_6 CX2 0 1G
R1G_7 RX_CX2 0 1G
* R1G_8 GND 0 1G
R1G_9 NA2 0 1G
R1G_10 B2 0 1G
R1G_11 NCLR2 0 1G
R1G_12 NQ2 0 1G
* R1G_13 Q1 0 1G
*R1G_14 CX1 0 1G
*R1G_15 RX_CX1 0 1G
* R1G_16 VCC 0 1G

.END
