************************************************************************
************************************************************************
*   Property of Texas Instruments Incorporated.  Unauthorized          *
*   reproduction and/or distribution is strictly prohibited.           *
*                                                                      *
*   This product is protected under copyright law.                     *
*   Created 2001, (C) Copyright 2001, Texas Instruments Inc.,          *
*   All Rights Reserved                                                *
*                                                                      *
*   UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE                 *
*   CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE          *
*   MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR              *
*   IMPLIED.  TI assumes no liability for:                             *
*   1) the accuracy of the SPICE models provided to your               *
*      company;                                                        *
*   2) the proper functioning of these SPICE models in your            *
*      design or for any resulting applications; or                    *
*   3) infringement of patents, copyrights or intellectual             *
*      property rights resulting from your use of these                *
*      SPICE models.                                                   *
*                                                                      *
*   TI provides SPICE Models as a service to our customers.            *
*   You and your company shall not distribute, sell or give            *
*   these models to anyone else without prior written                  *
*   permission from TI.                                                *
*                                                                      *
*   TI reserves the right to make changes to our products or           *
*   to discontinue any semiconductor product or service                *
*   without notice, and advises our customers to obtain the            *
*   latest version of relevant information to verify, before           *
*   placing orders, that the information being relied on is            *
*   current.                                                           *
*                                                                      *
*   Please be aware that your receipt and use of the SPICE             *
*   information provided shall serve as acceptance of these            *
*   terms and conditions.  If you do not accept these terms,           *
*   you should return or destroy the SPICE models and any              *
*   other accompanying information immediately.                        *
************************************************************************
************************************************************************
*   AHC1GU04 HSPICE Model                                               *
*   Standard Linear and Logic, Texas Instruments                       *
************************************************************************
************************************************************************
*   NOTE:                                                              *
*   The following files must be present to use this SPICE model:       *
*   ahc1gu04dev.dat      (netlist)                                     *
*   epic1s49n.dat        (Nominal process models, CMOS Level 49)       *
*   epic1s49s.dat        (Strong  process models, CMOS Level 49)       *
*   epic1s49w.dat        (Weak    process models, CMOS Level 49)       *
*   dbv5.pkg             (Package parasitics)                          *
*   dck5.pkg             (Package parasitics)                          *
*   READ.ME              (General use, release notes, ...)             *
************************************************************************
************************************************************************
*   The diagram below describes the nodes for the subcircuits:         *
*                                                                      *
*                  |\                                                  *
*        a ________| \o_________y                                      *
*                  | /                                                 *
*                  |/                                                  *
*                                                                      *
************************************************************************
************************************************************************
*   INSTRUCTIONS:                                                      *
*   Please refer to the 'READ.ME' file for general use instructions.   *
*   Include the following lines in your main netlist:                  *
************************************************************************

*INCLUDE PKG MODEL*
.include 'DBV5.PKG'
*.include 'DCK5.PKG'

   
* DEVICE NETLIST
.include 'ahc1gu04dev.inc'

*PROCESS MODEL. INCLUDE ONLY ONE*
.include 'epic1s49n.lib' $NOMINAL
*.include 'epic1s49w.lib' $WEAK
*.include 'epic1s49s.lib $STRONG



************************************************************************
*   Package connections                                                *
************************************************************************
    .SUBCKT AHC1GU04 p_a p_y p_vcc p_gnd
    XAHC1GU04_BIT s_a s_y s_gnd s_vcc ahc1gu04_bit
    X_PIN2       p_a              s_a             PKG5_02
    X_PIN4       p_y              s_y             PKG5_04
    X_PIN3       p_gnd            s_gnd           PKG5_03
    X_PIN5       p_vcc            s_vcc           PKG5_05
    .ENDS AHC1GU04
************************************************************************
*   HSPICE EXECUTION OPTIONS                                           *
************************************************************************
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-10     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-10   $ A conductance in parallel w/ PN junctions
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
    .TEMP    40             $ NOTE : SOME MODELS WILL NOT CONVERGE
************************************************************************
*   SUPPLIES                                                           *
************************************************************************
    XAHC1GU04 A Y VCC GND AHC1GU04
    vlogicsupply      VCC      0     DC    5.0
    vgnd              GND      0     DC    0.0

    .PARAM PVIL=0.0
    .PARAM PVIH=5.0
************************************************************************
*   TRANSIENT ANALYSES                                                 *
************************************************************************
    .TRAN         0.1NS 100NS
    Va      A     0     PULSE (PVIL PVIH 1NS 3NS 3NS 47NS 100NS)
    Cy      Y     0     50pF
    Ry      Y     0     500
    
    .END

