//*****************************************************************************
// THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
// REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,
// INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
// FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
// COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.
// TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET
// POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY
// INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
// YOUR USE OF THE PROGRAM.
//
// IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
// CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY
// THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED
// OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT
// OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.
// EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF
// REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS
// OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF
// USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
// AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF
// YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS
// (U.S.$500).
//
// Unless otherwise stated, the Program written and copyrighted
// by Texas Instruments is distributed as "freeware".  You may,
// only under TI's copyright in the Program, use and modify the
// Program without any charge or restriction.  You may
// distribute to third parties, provided that you transfer a
// copy of this license to the third party and the third party
// agrees to these terms by its first use of the Program. You
// must reproduce the copyright notice and any other legend of
// ownership on each copy or partial copy, of the Program.
//
// You acknowledge and agree that the Program contains
// copyrighted material, trade secrets and other TI proprietary
// information and is protected by copyright laws,
// international copyright treaties, and trade secret laws, as
// well as other intellectual property laws.  To protect TI's
// rights in the Program, you agree not to decompile, reverse
// engineer, disassemble or otherwise translate any object code
// versions of the Program to a human-readable form.  You agree
// that in no event will you alter, remove or destroy any
// copyright notice included in the Program.  TI reserves all
// rights not specifically granted under this license. Except
// as specifically provided herein, nothing in this agreement
// shall be construed as conferring by implication, estoppel,
// or otherwise, upon you, any license or other right under any
// TI patents, copyrights or trade secrets.
//
// You may not use the Program in non-TI devices.
//*****************************************************************************

#ifndef _STDINT_H_
#define _STDINT_H_

/*
 *	ISO C99: 7.18 Integer types <stdint.h>
 */
#ifndef __int8_t_defined
#define __int8_t_defined
typedef	char                                    int8_t;
typedef	int                                     int16_t;
typedef	long int                                int32_t;
#if defined(__GNUC__)
__extension__ typedef long long int             int64_t;
#endif

typedef	unsigned char                           uint8_t;
typedef	unsigned int                            uint16_t;
typedef	unsigned long int                       uint32_t;
#if defined(__GNUC__)
__extension__ typedef unsigned long long int    uint64_t;
#endif
#endif

/* Small types.  */

/* Signed.  */
typedef signed char		                        int_least8_t;
typedef int		                                int_least16_t;
typedef long int		                        int_least32_t;
#if defined(__GNUC__)
__extension__ typedef long long int	            int_least64_t;
#endif

/* Unsigned.  */
typedef unsigned char		                    uint_least8_t;
typedef unsigned int	                        uint_least16_t;
typedef unsigned long int	                    uint_least32_t;
#if defined(__GNUC__)
__extension__ typedef unsigned long long int    uint_least64_t;
#endif


/* Fast types.  */

/* Signed.  */
typedef signed char		                        int_fast8_t;
typedef int			                            int_fast16_t;
typedef long int	                            int_fast32_t;
#if defined(__GNUC__)
__extension__ typedef long long int             int_fast64_t;
#endif

/* Unsigned.  */
typedef unsigned char		                    uint_fast8_t;
typedef unsigned int		                    uint_fast16_t;
typedef unsigned long int		                uint_fast32_t;
#if defined(__GNUC__)
__extension__ typedef unsigned long long int	uint_fast64_t;
#endif


/* Types for `void *' pointers.  */
#ifndef __intptr_t_defined
#define __intptr_t_defined
typedef int			                            intptr_t;
typedef unsigned int		                    uintptr_t;
#endif


/* Largest integral types.  */
#if defined(__GNUC__)
__extension__ typedef long long int	            intmax_t;
__extension__ typedef unsigned long long int	uintmax_t;
#endif


/* The ISO C99 standard specifies that in C++ implementations these
   macros should only be defined if explicitly requested.  */
#if !defined __cplusplus || defined __STDC_LIMIT_MACROS

#define __INT64_C(c)	c ## LL
#define __UINT64_C(c)	c ## ULL

/* Limits of integral types.  */

/* Minimum of signed integral types.  */
#define INT8_MIN		(-128)
#define INT16_MIN		(-32767-1)
#define INT32_MIN		(-2147483647-1)
#define INT64_MIN		(-__INT64_C(9223372036854775807)-1)
/* Maximum of signed integral types.  */
#define INT8_MAX		(127)
#define INT16_MAX		(32767)
#define INT32_MAX		(2147483647)
#define INT64_MAX		(__INT64_C(9223372036854775807))

/* Maximum of unsigned integral types.  */
#define UINT8_MAX		(255)
#define UINT16_MAX		(65535)
#define UINT32_MAX		(4294967295U)
#define UINT64_MAX		(__UINT64_C(18446744073709551615))


/* Minimum of signed integral types having a minimum size.  */
#define INT_LEAST8_MIN		(-128)
#define INT_LEAST16_MIN	    (-32767-1)
#define INT_LEAST32_MIN	    (-2147483647-1)
#define INT_LEAST64_MIN	    (-__INT64_C(9223372036854775807)-1)
/* Maximum of signed integral types having a minimum size.  */
#define INT_LEAST8_MAX		(127)
#define INT_LEAST16_MAX	    (32767)
#define INT_LEAST32_MAX	    (2147483647)
#define INT_LEAST64_MAX	    (__INT64_C(9223372036854775807))

/* Maximum of unsigned integral types having a minimum size.  */
#define UINT_LEAST8_MAX	    (255)
#define UINT_LEAST16_MAX	(65535)
#define UINT_LEAST32_MAX	(4294967295U)
#define UINT_LEAST64_MAX	(__UINT64_C(18446744073709551615))


/* Minimum of fast signed integral types having a minimum size.  */
#define INT_FAST8_MIN		(-128)
#define INT_FAST16_MIN	    (-32768)
#define INT_FAST32_MIN	    (-2147483647-1)
#define INT_FAST64_MIN		(-__INT64_C(9223372036854775807)-1)
/* Maximum of fast signed integral types having a minimum size.  */
#define INT_FAST8_MAX		(127)
#define INT_FAST16_MAX	    (32767)
#define INT_FAST32_MAX	    (2147483647)
#define INT_FAST64_MAX		(__INT64_C(9223372036854775807))

/* Maximum of fast unsigned integral types having a minimum size.  */
#define UINT_FAST8_MAX		(255U)
#define UINT_FAST16_MAX	    (65535U)
#define UINT_FAST32_MAX	    (4294967295UL)
#define UINT_FAST64_MAX	    (__UINT64_C(18446744073709551615))


/* Values to test for integral types holding `void *' pointer.  */
#define INTPTR_MIN		    (-32768)
#define INTPTR_MAX		    (32767)
#define UINTPTR_MAX		    (65535U)


/* Minimum for largest signed integral type.  */
#define INTMAX_MIN		    (-__INT64_C(9223372036854775807)-1)
/* Maximum for largest signed integral type.  */
#define INTMAX_MAX		    (__INT64_C(9223372036854775807))

/* Maximum for largest unsigned integral type.  */
#define UINTMAX_MAX		    (__UINT64_C(18446744073709551615))


/* Limits of other integer types.  */

/* Limits of `ptrdiff_t' type.  */
#define PTRDIFF_MIN		    (-32768)
#define PTRDIFF_MAX		    (32767)

/* Limits of `sig_atomic_t'.  */
#define SIG_ATOMIC_MIN		(-32768)
#define SIG_ATOMIC_MAX		(32767)

/* Limit of `size_t' type.  */
#define SIZE_MAX		    (65535U)

/* Limits of `wchar_t'.  */
#ifndef WCHAR_MIN
/* These constants might also be defined in <wchar.h>.  */
#define WCHAR_MIN		__WCHAR_MIN
#define WCHAR_MAX		__WCHAR_MAX
#endif

/* Limits of `wint_t'.  */
#define WINT_MIN		(0U)
#define WINT_MAX		(65535U)

#endif	/* C++ && limit macros */


/* The ISO C99 standard specifies that in C++ implementations these
   should only be defined if explicitly requested.  */
#if !defined __cplusplus || defined __STDC_CONSTANT_MACROS

/* Signed.  */
#define INT8_C(c)	    c
#define INT16_C(c)	    c
#define INT32_C(c)	    c
#define INT64_C(c)	    c ## LL

/* Unsigned.  */
#define UINT8_C(c)	    c ## U
#define UINT16_C(c)	    c ## U
#define UINT32_C(c)	    c ## U
#define UINT64_C(c)	    c ## ULL

/* Maximal type.  */
#define INTMAX_C(c)	    c ## LL
#define UINTMAX_C(c)    c ## ULL

#endif	/* C++ && constant macros */
#endif
