/*
 * Camera_Motor_EVM.h
 *
 *  Created on: May 6, 2020
 *      Author: a0273119
 */

#ifndef CAMERA_MOTOR_EVM_H_
#define CAMERA_MOTOR_EVM_H_

/******************************************************************************
 * Customizable Macros:
 * Modify these values to configure the motor behavior
*/
/**
 * General
 */
#define MOTOR_DRIVE_INPUT_VOLTAGE        5.0        /*Input Voltage for BLDC IRIS motor driver*/

/**
 * Iris Motor
 */
#define IRIS_MOTOR_ENABLE               1           /*Enable=1, Disable=0*/
#define IRIS_MOTOR_VOLTAGE              3.7         /*Target voltage on Iris motor after BLDC Driver (Speed/strength setting)*/
#define IRIS_MOTOR_PWM_FREQ_HZ          10000       /*Input range= 500Hz - 250kHz*/
#define IRIS_MOTOR_RUN_TIME_SECONDS     10.0        /*Input range= .01s  - 60s*/
#define IRIS_MOTOR_DIRECTION            Clockwise   /*Direction of rotation*/

/**
 * Focus Motor
 */
#define FOCUS_MOTOR_ENABLE              1           /*Enable=1, Disable=0*/
#define FOCUS_MOTOR_SPEED_PPS           100         /*Pulses per second, Input range= 50Hz - 100kHz*/
#define FOCUS_MOTOR_PULSE_COUNT         1000         /*Number of pulses before timeout*/
#define FOCUS_MOTOR_DIRECTION           Clockwise   /*Direction of rotation*/
#define FOCUS_MOTOR_STEP_SIZE           Step_Full   /*Step size setting.  See DRV8428_Step_Size type below for options*/

/**
 * Tilt Motor
 */
#define TILT_MOTOR_ENABLE               1           /*Enable=1, Disable=0*/
#define TILT_MOTOR_SPEED_PPS            100         /*Pulses per second, Input range= 50Hz - 100kHz*/
#define TILT_MOTOR_PULSE_COUNT          1000         /*Number of pulses before timeout*/
#define TILT_MOTOR_DIRECTION            Clockwise   /*Direction of rotation*/
#define TILT_MOTOR_STEP_SIZE            Step_Full   /*Step size setting.  See DRV8428_Step_Size type below for options*/
//END*****************************************************************************



/******************************************************************************
 * Functions, Variables, and Structures
 *****************************************************************************/
//void Start_Motors(void);
void Start_IRIS_Motor(void);
void Start_Focus_Motor(void);
void Start_Tilt_Motor(void);


void Init_Iris_Motor(void);
void Init_Focus_Motor(void);
void Init_Tilt_Motor(void);
void Focus_Motor_Update_Direction(void);
void Tilt_Motor_Update_Direction(void);

enum Direction {
    Clockwise, Counter_Clockwise
};

enum DRV8428_Step_Size {    //  M0,  M1     // Defined in Table 4 of DRV8428 Datasheet
    Step_Full,              //   0,   0     //Full step 100%
    /*Step_Full_71,*/       //   0, 330k    //No 330k resistor currently
    Step_1_2_Noncircular,   //   1,   0
    Step_1_2,               //Hi-Z,   0
    Step_1_4,               //   0,   1
    Step_1_8,               //   1,   1
    Step_1_16,              //Hi-Z,   1
    Step_1_32,              //   0, Hi-Z
    /*Step_1_64,*/          //Hi-Z, 330k    // No 330k resistor currently
    Step_1_128,             //Hi-Z, Hi-Z
    Step_1_256              //   1, Hi-Z
};

extern enum Direction IrisMotorDirection;
extern unsigned int g_uiFocusMotorPulseCount;
extern enum Direction FocusMotorDirection;
extern enum DRV8428_Step_Size FocusMotorStepSetting;
extern unsigned int g_uiTiltMotorPulseCount;
extern enum Direction TiltMotorDirection;
extern enum DRV8428_Step_Size TiltMotorStepSetting;




/******************************************************************************
 * System and Hardware MACROS
 *****************************************************************************/
#define SMCLK_FREQ  24000000  //24MHz

/*
 * IRIS - BLDC Motor Driver Interface: DRV8837
 */
#define IRIS_IN2            BIT0    // P2.0: M1 330k pulldown
#define IRIS_IN1            BIT1    // P2.1: DECAY1 for STEP/DIR variant
#define IRIS_nSLEEP         BIT3    // P3.3: Sleep mode for Iris motor driver
//IRIS software macros
#define IRIS_SLEEP              P3OUT &= ~IRIS_nSLEEP;                     // Wake up motor driver
#define IRIS_WAKEUP             P3OUT |= IRIS_nSLEEP;                     // Wake up motor driver
#define IRIS_BRAKE              P2OUT |= IRIS_IN1 + IRIS_IN2;  P2DIR |= IRIS_IN1 + IRIS_IN2;  P2SEL0 &= ~(IRIS_IN1 + IRIS_IN2);
#define IRIS_COAST              P2OUT &= ~(IRIS_IN1 + IRIS_IN2);  P2DIR |= IRIS_IN1 + IRIS_IN2;  P2SEL0 &= ~(IRIS_IN1 + IRIS_IN2);


/*
 * Focus - Stepper Motor Driver Interface: DRV8428
 */
#define FOCUS_M0            BIT4    // P1.4: Stepper Motor mode select pins
#define FOCUS_M1            BIT5    // P1.5: Stepper Motor mode select pins
#define FOCUS_STEP      BIT6    // P1.6/TB0.1 output: Stepper motor Step input
#define FOCUS_nSLEEP        BIT4    // P3.4: Sleep mode for Focus motor driver
#define FOCUS_nFAULT        BIT5    // P3.5: input, fault interrupt from stepper driver
#define FOCUS_EN            BIT6    // P3.6: Focus motor enable signal
#define FOCUS_DIR           BIT7    // P3.7: Direction bit for Focus Motor driver
//Focus software macros
#define FOCUS_ENABLE        P3OUT |= FOCUS_EN;
#define FOCUS_DISABLE       P3OUT &= ~FOCUS_EN; TB0CTL = MC__STOP;              //Stop the timer
#define FOCUS_STEP_PIN_HIGH     P1OUT |= FOCUS_STEP;
#define FOCUS_STEP_PIN_LOW     P1OUT &= ~FOCUS_STEP;


/*
 * Tilt - Stepper Motor Driver Interface: DRV8428
 */
#define TILT_STEP           BIT7    // P1.7: Stepper motor Step input
#define TILT_M0             BIT4    // P2.4: Stepper Motor mode select pins
#define TILT_M1             BIT5    // P2.5: Stepper Motor mode select pins
#define TILT_DIR            BIT0    // P4.0: Direction bit for tilt motor driver
#define TILT_EN             BIT1    // P4.1: Tilt motor enable signal   **This is the correct signal for the EVM**
//#define TILT_EN             BIT5    // P4.5: Tilt motor enable signal  ** for testing purposes on the launchpad only***
#define TILT_nFAULT         BIT6    // P4.6: input, fault interrupt from stepper driver
#define TILT_nSLEEP         BIT7    // P4.7: Sleep mode for Tilt motor
//Tilt software macros
#define TILT_ENABLE             P4OUT |= TILT_EN;
#define TILT_DISABLE            P4OUT &= ~TILT_EN; TB2CTL = MC__STOP;
#define TILT_STEP_PIN_HIGH      P1OUT |= TILT_STEP;
#define TILT_STEP_PIN_LOW       P1OUT &= ~TILT_STEP;

/*
 * Photo Interrupter - Using built in comparator
 */
#define PI_INPUT            BIT1    // P1.1: Photo interrupter (input to comparator.)
#define PI_INT              BIT1    // P3.1: Interrupt signal?  Output from comparator.
#define PI_EN               BIT2    // P3.2: Photo interrupter enable?


/*
 * Comms -
 */
#define SDA                 BIT2    // P1.2: I2C
#define SCL                 BIT3    // P1.3: I2C
#define RXD                 BIT2    // P4.2: UART
#define TXD                 BIT3    // P4.3: UART

/*
 * Inputs
 */
#define SPEED_REF           BIT0    // P1.0: Potentiometer Analog input
#define CAM_M_MIN           BIT6    // P2.6: interrupt?
#define CAM_M_MAX           BIT7    // P2.7: interrupt?
#define DIR                 BIT0    // P3.0: maybe a possible direction input??

//*************************************************************************************//


//HAL GPIO Macros organized by GPIO port instead of function
///*
// * GPIO Port 1 Definitions
// */
//#define SPEED_REF           BIT0         // P1.0: Potentiometer Analog input
//#define PI_INPUT            BIT1         // P1.1: Photo interrupter (input to comparator.)
//#define SDA                 BIT2         // P1.2: I2C
//#define SCL                 BIT3         // P1.3: I2C
//#define FOCUS_M0            BIT4         // P1.4: Stepper Motor mode select pins
//#define FOCUS_M1            BIT5         // P1.5: Stepper Motor mode select pins
//#define FOCUS_STEP          BIT6         // P1.6: Stepper motor Step input
//#define TILT_STEP           BIT7         // P1.7: Stepper motor Step input
//
///*
// * GPIO Port 2 Definitions
// */
//#define IRIS_IN2            BIT0         // P2.0: M1 330k pulldown
//#define IRIS_IN1            BIT1         // P2.1: DECAY1 for STEP/DIR variant
//
//#define TILT_M0             BIT4         // P2.1: Stepper Motor mode select pins
//#define TILT_M1             BIT5         // P2.3: Stepper Motor mode select pins
//#define CAM_M_MIN           BIT6         // P2.6: interrupt?
//#define CAM_M_MAX           BIT7         // P2.7: interrupt?
//
///*
// * GPIO Port 3 Definitions
// */
//#define DIR                 BIT0            // P3.0: ????    maybe an input??
//#define PI_INT              BIT1         // P3.1: Interrupt signal?  Output from comparator.
//#define PI_EN               BIT2         // P3.2: Photo interrupter enable?
//#define IRIS_nSLEEP         BIT3         // P3.3: Sleep mode for Iris motor driver
//#define FOCUS_nSLEEP        BIT4         // P3.4: Sleep mode for Focus motor driver
//#define FOCUS_nFAULT        BIT5         // P3.5: input, fault interrupt from stepper driver
//#define FOCUS_EN            BIT6         // P3.6: Focus motor enable signal
//#define FOCUS_DIR           BIT7         // P3.7: Direction bit for Focus Motor driver
//
///*
// * GPIO Port 4 Definitions
// */
//#define TILT_DIR            BIT0         // P4.0: Direction bit for tilt motor driver
//#define TILT_EN             BIT1         // P4.1: Tilt motor enable signal
//#define RXD                 BIT2         // P4.2: UART
//#define TXD                 BIT3         // P4.3: UART
//
//#define TILT_nFAULT         BIT6         // P4.6: input, fault interrupt from stepper driver
//#define TILT_nSLEEP         BIT7         // P4.7: Sleep mode for Tilt motor


#endif /* CAMERA_MOTOR_EVM_H_ */
