/* SPDX-License-Identifier: GPL-2.0-only */
// BQ2562X Charger Driver
// Copyright (C) 2020 Texas Instruments Incorporated - http://www.ti.com/

#ifndef _BQ2562X_CHARGER_H
#define _BQ2562X_CHARGER_H

#define BQ2562X_NUM_WD_VAL  4

#include "ti_msp_dl_config.h"

typedef enum {
    BQ2562X_USB_SDP = 0b001,                    //Standard Downstream Port
    BQ2562X_USB_CDP = 0b010,                   //Charging Downstream Port
    BQ2562X_USB_DCP = 0b011,                   //Dedicated Charging Port
    BQ2562X_UNKNOWN_500MA = 0b100,
    BQ2562X_NON_STANDARD = 0b101,                   //vendor specific adapters
                                                   //Comparators will detect the voltage applied on D+ D- pin
    BQ2562X_HVDCP = 0b110,              //High Voltage Dedicated Charging Port
    BQ2562X_OTG_MODE = 0b111,  //Deliver power from the battery to VBUS
}bc1p2_mode;

typedef enum {
    CHARGING_DISABLED = 0b00,
    CONSTANT_CURRENT = 0b01,
    CONSTANT_VOLTAGE = 0b10,
    TOPOFF_CHARGING = 0b11,
}chg_status;

typedef struct {
    uint32_t constant_charge_current_max_ua;
    uint32_t constant_charge_voltage_max_uv;
    uint32_t precharge_current_ua;
    uint32_t charge_term_current_ua;
}battery_info;

typedef struct {
    uint32_t iInputHighLim_uA;
    uint32_t vInputLowlim_uV;
    uint32_t watchdog_timer_s;
}bq2562x_init_data;

typedef struct {
    chg_status chrg_status;
    bc1p2_mode chrg_type;
    uint8_t health;
    uint8_t fault_0;
    uint32_t vbat_adc_uV;
    uint32_t vbus_adc_uV;
    uint32_t ibat_adc_uA;
    uint32_t ibus_adc_uA;
}bq2562x_state;

// Structure to represent the BQ2562x device
typedef struct {
    battery_info * bat_info;
    bq2562x_init_data * init_data;
    bq2562x_state state;
} bq2562x_device;



static uint32_t bq2562x_watchdog_time[BQ2562X_NUM_WD_VAL] = {0, 50, 100, 200};
void bq2562x_get_state(bq2562x_device *bq);
void bq2562x_hw_init(bq2562x_device *bq);
#endif /* _BQ2562X_CHARGER_H */
