/*
 * Copyright (c) 2021, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "ti_msp_dl_config.h"
#include "bq2562x_charger.h"

//*******************Parameter Init***************************//
battery_info batt_info = {
    .constant_charge_current_max_ua = 1040000,  //1A
    .constant_charge_voltage_max_uv = 42000000, //4.2V
    .precharge_current_ua = 100000,
    .charge_term_current_ua = 60000,
};

bq2562x_init_data bq_init_data = {
    .iInputHighLim_uA = 600000,
    .vInputLowlim_uV = 4600000,
    .watchdog_timer_s = 0,
};

bq2562x_device bq_device = {
    .bat_info = &batt_info,
    .init_data = &bq_init_data,
};

//*******************Main function***************************//
int main(void)
{
    SYSCFG_DL_init();
    NVIC_EnableIRQ(I2C_0_INST_INT_IRQN);
    DL_I2C_enableControllerClockStretching(I2C_0_INST);
    bq2562x_hw_init(&bq_device);

    while (1) {
        delay_cycles(1000000);
        bq2562x_get_state(&bq_device);
    }
}
