************************************************************************
* TMDS442 HSPICE run file
************************************************************************
************************************************************************
* HSPICE version : X-2005.09-SP1   
************************************************************************
* DISCLAIMER :
************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized   *
*          reproduction and/or distribution is strictly prohibited.    *
*                                                                      *
*          This product is protected under copyright law.              *
*          Created 2005, (C) Copyright 2005, Texas Instruments Inc.,   *
*          All Rights Reserved                                         *
*                                                                      *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE          *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE   *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR       *
*          IMPLIED.  TI assumes no liability for:                      *
*          1) the accuracy of the SPICE models provided to your        *
*             company;                                                 *
*          2) the proper functioning of these SPICE models in your     *
*             design or for any resulting applications; or             *
*          3) infringement of patents, copyrights or intellectual      *
*             property rights resulting from your use of these         *
*             SPICE models.                                            *
*                                                                      *
*          TI provides SPICE Models as a service to our customers.     *
*          You and your company shall not distribute, sell or give     *
*          these models to anyone else without prior written           *
*          permission from TI.                                         *
*                                                                      *
*          TI reserves the right to make changes to our products or    *
*          to discontinue any semiconductor product or service         *
*          without notice, and advises our customers to obtain the     *
*          latest version of relevant information to verify, before    *
*          placing orders, that the information being relied on is     *
*          current.                                                    *
*                                                                      *
*          Please be aware that your receipt and use of the SPICE      *
*          information provided shall serve as acceptance of these     *
*          terms and conditions.  If you do not accept these terms,    *
*          you should return or destroy the SPICE models and any       *
*          other accompanying information immediately.                 *
*                                                                      *
*          Contact Texas Instruments at ATTN:DATA TRANSMISSIONS        *
************************************************************************
************************************************************************
************************************************************************
*** Description of the circuit included in this netlist:
***
*** The netlist contains only high speed inputs and outputs (TMDS signals).
***
*** All of the control signals and their circuits were purposely taken 
*** out of this netlist for simplicity. The list of signlas omitted is:
*** SCLX, SDAX, SCLK_SINKX, SDA_SINKX, HPDX, HPD_SINKX, 5V_PWRX, 5V_SINKX
*** LC_SCL, SC_SDA, LC_AX, GE, GPIOX. 
***
*** However, for those who are interested in observing 4to2 mux function of
*** TMDS signals, a special set of control pins has been created: s11, s12,
*** s13, s14, s21, s22, s23, and s24. 
***
*** The following configuration accoumplishes Source Port1 being output to 
*** Sink Port1 and Source Port2 being output to Sink Port2:
*** s11=high, s12=s13=s14=low, s22= high, s21=s23=s24=low
***
*** Similiarly, the configuration of s13=high, s11=s12=s14=low , s21=high,
*** s22=s23=s24=low will result in Source Port1 being output to Sink Port3
*** and Source Port1 being output to Sink Port2.
***
***
***  The following is a description of Pins/Signals:
***  
***
***  Signal                         Description
***
***   vcc                            power (3.3V)
***   gnd                            ground
***   a11,a12,a13,a14              Source port1 TMDS positive inuts
***   a21,a22,a23,a24              Source port2 TMDS positive inuts
***   a31,a32,a33,a34              Source port3 TMDS positive inuts
***   a41,a42,a43,a44              Source port4 TMDS positive inuts
***   b11,b12,b13,b14              Source port1 TMDS negative inuts
***   b21,b22,b23,b24              Source port2 TMDS negative inuts
***   b31,b32,b33,b34              Source port3 TMDS negative inuts
***   b41,b42,b43,b44              Source port4 TMDS negative inuts
***   y11,y12,y13,y14              Sink port1 TMDS positive outputs
***   y21,y22,y23,y24              Sink port2 TMDS positive outputs
***   s11                          when high, Source port1 is connected to Sink port1
***   s12                          when high, Source port2 is connected to Sink port1
***   s13                          when high, Source port3 is connected to Sink port1
***   s14                          when high, Source port4 is connected to Sink port1
***   s21                          when high, Source port1 is connected to Sink port2
***   s22                          when high, Source port2 is connected to Sink port2
***   s23                          when high, Source port3 is connected to Sink port2
***   s24                          when high, Source port4 is connected to Sink port2
***
******************************************************************************************
******************************************************************************************
******************************************************************************************



**********************************************************************
***********                 CIRCUIT CALL               ***************
**********************************************************************
XITOP gnd vcc gnd gnd vcc gnd gnd gnd vcc gnd gnd gnd vcc gnd y21 z21 y22 vsadj gnd gnd gnd gnd y12 z12 y13 z13 y14 z14 gnd vcc gnd gnd gnd gnd vcc vcc vcc gnd gnd gnd gnd a13 b13 a14 b14 a11 b11 a12 b12 b24 a24 b23 a23 b22 a22 b21 a21 a31 b31 a32 b33 a34 b34 a33 b32 a41 b41 a42 b42 a43 b43 a44 b44 gnd gnd gnd y23 z22 z11 y24 z24 z23 y11 gnd gnd gnd gnd gnd gnd oe1 pre1 pre2 oe2 s24 s23 s14 vcc s22 s21 s13 s12 s11 gnd gnd gnd top_tmds442



**********************************
***Mux control signals
********************************
V36 s11 0 DC=vcc
V37 s12 0 DC=0
V38 s13 0 DC=0
V39 s14 0 DC=0
V43 s21 0 DC=0
V42 s22 0 DC=vcc
V41 s23 0 DC=0
V40 s24 0 DC=0



****************************
*** Power Sources and ground
****************************
.PARAM vcc=3.3
VVCC vcc 0 DC=vcc
VGND gnd 0 DC=0


**************************************
*** Output termination voltage (AVcc)
**************************************
V48 vst 0 DC=vcc



****************************************************************************
***Input stimuli
*****************************************************************************
V47 a21 0 AC 0 0 PULSE vcc 'vcc-300e-3' 0 200e-12 200e-12 400e-12 1.2e-9
V46 b21 0 AC 0 0 PULSE 'vcc-300e-3' vcc 0 200e-12 200e-12 400e-12 1.2e-9
V45 b11 0 AC 0 0 PULSE vcc 'vcc-300e-3' 0 200e-12 200e-12 400e-12 1.2e-9
V44 a11 0 AC 0 0 PULSE 'vcc-300e-3' vcc 0 200e-12 200e-12 400e-12 1.2e-9
V35 oe1 0 DC=0
V34 oe2 0 DC=0
V32 pre2 0 DC=0
V33 pre1 0 DC=0
V31 b41 0 DC='vcc-300e-3'
V30 a41 0 DC=vcc
V29 a42 0 DC=vcc
V28 b42 0 DC='vcc-300e-3'
V27 b43 0 DC='vcc-300e-3'
V26 a43 0 DC=vcc
V25 a44 0 DC=vcc
V23 b44 0 DC='vcc-300e-3'
V21 b34 0 DC='vcc-300e-3'
V20 a34 0 DC=vcc
V19 a33 0 DC=vcc
V18 b33 0 DC='vcc-300e-3'
V17 b32 0 DC='vcc-300e-3'
V16 a32 0 DC=vcc
V15 a31 0 DC=vcc
V14 b31 0 DC='vcc-300e-3'
V11 a22 0 DC=vcc
V10 b22 0 DC='vcc-300e-3'
V9 b23 0 DC='vcc-300e-3'
V8 a23 0 DC=vcc
V7 a24 0 DC=vcc
V6 b24 0 DC='vcc-300e-3'
V5 b14 0 DC='vcc-300e-3'
V4 a14 0 DC=vcc
V3 a13 0 DC=vcc
V2 b13 0 DC='vcc-300e-3'
V1 b12 0 DC='vcc-300e-3'
V0 a12 0 DC=vcc



*************************
****Output terminations
*************************
C25 z23 0 1e-12
C27 z24 0 1e-12
C22 y22 0 1e-12
C23 z22 0 1e-12
C10 y14 0 1e-12
C7 z12 0 1e-12
C9 z13 0 1e-12
C21 z21 0 1e-12
C5 z11 0 1e-12
C6 y12 0 1e-12
C20 y21 0 1e-12
C11 z14 0 1e-12
C1 y11 0 1e-12
C24 y23 0 1e-12
C8 y13 0 1e-12
C26 y24 0 1e-12
R0 vsadj 0 4.64e3
R28 vst y24 50
RY11 vst y11 50
R26 vst z22 50
R25 vst y23 50
RY21 vst y21 50
R23 vst y12 50
RZ11 vst z11 50
R21 vst z23 50
RY13 vst y13 50
R17 vst z12 50
R18 vst z24 50
R20 vst y22 50
RZ21 vst z21 50
R15 vst z13 50
R14 vst z14 50
R13 vst y14 50


******************
*** Process models
******************
.INCLUDE   nom.inc


******************
*** Device model
******************
.INCLUDE tmds442.inc

.OP
.SAVE


.TEMP 25
.TRAN 1e-12 2e-9 START=0.0

.PROBE TRAN
+    V(a11)
+    V(b11)
+    V(a21)
+    V(b21)
+    V(a12)
+    V(b12)
+    V(y11)
+    V(z11)
+    V(y12)
+    V(z12)
+    V(y21)
+    V(z21)



.OPTION ACCT ACCURATE NOPAGE OPTS POST=1 PROBE



.END
