// includes list of IPs commonly used

module ffs #(parameter width=1)
 (
  output reg [width-1:0] q,
  input      [width-1:0] d,
  input      [width-1:0] init,
  input                clk,
  input                rstn
  `ifndef SYN_TRUE
  ,
  input                debug
  `endif
 );
  always @(posedge clk)
    if (!rstn) begin
      q <= init;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Value of init from ffs %0h",$realtime, init); 
      `endif
    end
    else begin
      q <= d;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Value of data from ffs %0h",$realtime, d);
      `endif
    end
endmodule // ffs


module ffas #(parameter width=1)
 (
  output reg [width-1:0] q,
  input      [width-1:0] d,
  input      [width-1:0] init,
  input                clk,
  input                rstn
  `ifndef SYN_TRUE
  ,
  input                debug
  `endif
 );
  always @(posedge clk or negedge rstn)
    if (!rstn) begin
      q <= init;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Value of init from ffas %0h",$realtime, init);
      `endif
    end
    else begin
      q <= d;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Value of data from ffas %0h",$realtime, d);
      `endif
    end
endmodule // ffas

module counter #(parameter width=1)
 (
  output reg [width-1:0] cnt,
  output reg             done,
  input      [width-1:0] init,
  input      [width-1:0] thsld,
  input                  clk,
  input                  rstn,
  input                  en,
  input                  round
  `ifndef SYN_TRUE
  ,
  input                  debug
  `endif
 );
  always @(posedge clk or negedge rstn)
    if (!rstn) begin
      cnt <= init;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Value of init from counter %0h",$realtime, init);
      `endif    end
    else if (en) begin
      if ((cnt == thsld) || (&cnt)) begin
	 if (round) begin
   	   cnt <= init;
         `ifndef SYN_TRUE
         if (debug)
           $display("[DEBUG]%t: Restart of count from counter %0h",$realtime, init);
         `endif
	 end
         else begin
	   cnt <= cnt;
           `ifndef SYN_TRUE
           if (debug)
	     $display("[DEBUG]%t: Holding of count from counter %0h",$realtime, cnt);
           `endif
         end // else: !if(round)
      end // if ((cnt == thsld) || (&cnt))
      else begin
	cnt <= cnt + 1;
	`ifndef SYN_TRUE
        if (debug)
	  $display("[DEBUG]%t: Increment count from counter %0h",$realtime, cnt);
        `endif
      end // else: !if((cnt == thsld) || (&cnt))
    end // if (en)
    else begin
      cnt <= cnt;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Value of hold from counter %0h",$realtime, cnt);
      `endif
    end // else: !if(en)

  always @(posedge clk or negedge rstn)
    if (!rstn) begin
      done <= 1'b0;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Done reset from counter",$realtime);
      `endif
    end
    else if ((cnt == thsld) || (&cnt)) begin
      done <= 1'b1;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Done set from counter",$realtime);
      `endif
    end
    else begin
      done <= 1'b0;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Done reseted from counter",$realtime);
      `endif
    end
endmodule // counter


module counter_pulse_start #(parameter width=1)
 (
  output reg [width-1:0] cnt,
  output reg             busy,
  input      [width-1:0] init,
  input      [width-1:0] thsld,
  input                  clk,
  input                  rstn,
  input                  en,
  input                  round
  `ifndef SYN_TRUE
  ,
  input                  debug
  `endif
 );
  always @(posedge clk or negedge rstn)
    if (!rstn) begin
      cnt <= init;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Value of init from counter %0h",$realtime, init);
      `endif    end
    else if (en || (|cnt)) begin
      if ((cnt == thsld) || (&cnt)) begin
	 if (round) begin
   	   cnt <= init;
         `ifndef SYN_TRUE
         if (debug)
           $display("[DEBUG]%t: Restart of count from counter %0h",$realtime, init);
         `endif
	 end
         else begin
	   cnt <= cnt;
           `ifndef SYN_TRUE
           if (debug)
	     $display("[DEBUG]%t: Holding of count from counter %0h",$realtime, cnt);
           `endif
         end // else: !if(round)
      end // if ((cnt == thsld) || (&cnt))
      else begin
	cnt <= cnt + 1;
	`ifndef SYN_TRUE
        if (debug)
	  $display("[DEBUG]%t: Increment count from counter %0h",$realtime, cnt);
        `endif
      end // else: !if((cnt == thsld) || (&cnt))
    end // if (en)
    else begin
      cnt <= cnt;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Value of hold from counter %0h",$realtime, cnt);
      `endif
    end // else: !if(en || (|cnt))

  always @(posedge clk or negedge rstn)
    if (!rstn) begin
      busy <= 1'b0;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Busy reset from counter",$realtime);
      `endif
    end
    else if ((en || (|cnt)) && (cnt!=thsld)) begin
      busy <= 1'b1;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Busy set from counter",$realtime);
      `endif
    end
    else begin
      busy <= 1'b0;
      `ifndef SYN_TRUE
      if (debug)
	$display("[DEBUG]%t: Busy reseted from counter",$realtime);
      `endif
    end
endmodule // counter_pulse_start


module apb_reg #(parameter ADDR_W=1, parameter DATA_W=1)
 (
  output reg [DATA_W-1:0] prd_data,
  input      [ADDR_W-1:0] address,
  input      [DATA_W-1:0] prst_data,
  input      [ADDR_W-1:0] paddr,
  input      [DATA_W-1:0] pwr_data,
  input                   pclk,
  input                   prstn,
  input                   pwr
 );

  always @(posedge pclk or negedge prstn)
    if(!prstn)
      prd_data  <= prst_data;
    else if(pwr && (address == paddr))
      prd_data  <= pwr_data;
    else
      prd_data  <= prd_data;

endmodule // apb_reg


module apb_reg_wracc #(parameter ADDR_W=1, parameter DATA_W=1)
 (
  output reg [DATA_W-1:0] prd_data,
  input      [ADDR_W-1:0] address,
  input      [DATA_W-1:0] prst_data,
  input      [ADDR_W-1:0] paddr,
  input      [DATA_W-1:0] pwr_data,
  input                   pclk,
  input                   prstn,
  input                   pwr,
  input      [DATA_W-1:0] reg_data
 );

  always @(posedge pclk or negedge prstn)
    if(!prstn)
      prd_data  <= prst_data;
    else if(pwr && (address == paddr))
      prd_data  <= pwr_data;
    else
      prd_data  <= reg_data;

endmodule // apb_reg_wracc

// Local Variables:
// verilog-library-directories : (".")
// End:
