*//////////////////////////////////////////////////////////////////////
* (C) National Semiconductor, Inc.
* Models developed and under copyright by:
* National Semiconductor, Inc.  

*/////////////////////////////////////////////////////////////////////
* Legal Notice: This material is intended for free software support.
* The file may be copied, and distributed; however, reselling the 
*  material is illegal

*////////////////////////////////////////////////////////////////////
* For ordering or technical information on these models, contact:
* National Semiconductor's Customer Response Center
*                 7:00 A.M.--7:00 P.M.  U.S. Central Time
*                                (800) 272-9959
* For Applications support, contact the Internet address:
*  amps-apps@galaxy.nsc.com

* ///////////////////////////////////////////////////////////////////
* User Notes:
*
* 1. Input resistance (Rin) for these JFET op amps is 1TOhm.  Rin is
*    modeled by assuming the option GMIN=1TOhm.  If a different (non-
*    default) GMIN value is needed, users may recalculate as follows:
*    Rin=(R1||GMIN+R2||GMIN), where R1=R2,
*    to maintain a consistent Rin model.

* ///////////////////////////////////////////////////////////////////
* //////////////////////////////////////////////////////
* LF442A Dual Low Power JFET Input Operational Amplifier
* //////////////////////////////////////////////////////
*
* Connections:    Non-inverting input
*                 |   Inverting input
*                 |   |   Positive power supply
*                 |   |   |   Negative power supply
*                 |   |   |   |   Output
*                 |   |   |   |   |
*                 |   |   |   |   |
.SUBCKT LF442A/NS 1   2  99  50  28
*
* Features:
* Low input bias current =             10pA
* High bandwidth =                     1MHz
* High slew rate =                    1V/uS
* Low offset voltage (max) =            1mV
* Low supply current =                150uA/Amplifier
*
* Note: Model is for single device only and simulated
*       supply current is 1/2 of total device current.
*
****************INPUT STAGE************** 
*
* Input offset current      
IOS 2 1 2.5P                
CI1 1 50 2.5P
CI2 2 50 2.5P
R1 1 3 1E12
R2 3 2 1E12
I1 99 4 100U
IB1 4 7 48P
IB2 4 2 48P
J1 5 2 4 JX
J2 6 7 4 JX
R3 5 50 3.956K
R4 6 50 3.956K
* Fp2=5.02 MHZ
C4 31 6 7P 
R20 31 5 1500
* Fz1=15.1 MHZ
*
***********COMMON MODE EFFECT***********
*
* Supply current    
I2 99 50 44UA                 
* Input offset voltage| 
EOS 7 1 POLY(1) 16 49 1E-3 1  
R8 99 49 1.25E6
R9 49 50 1.25E6
*
*********OUTPUT VOLTAGE LIMITING********
V2 99 8 2.63
D1 9 8 DX
D2 10 9 DX
V3 10 50 2.63
D7  22 99 DX
D8  50 22 DX
*
**************SECOND STAGE**************
*
* Level shifter  
EH 99 98 99 49 1              
F1 9 98 POLY(1) VA3 0 0 0 2E6
G1 98 9 5 6 20E-3
R5 98 9 10MEG
VA3 9 11 0
* Fp1=11.5 HZ
C3 98 11 1385P
*
***************POLE STAGE***************
*
* Fp3=159 MHz
G3 98 15 9 49 1E-6
R12 98 15 1MEG
C5 98 15 1E-15
*
*********COMMON-MODE ZERO STAGE*********
*
G4 98 16 POLY(2) 1 49 2 49 0 0.5E-8 0.5E-8
L2 98 17 5.1
R13 17 16 1K
*
**************OUTPUT STAGE**************
*
* Supply current correction  
F6 50 99 POLY(1) V6 30U 1    
E1 99 23 99 15 1               
* Output resistance        
R16 24 23 675               
D5 26 24 DX
V6 26 22 0.63V
R17 23 25 250      
D6 25 27 DX
V7 22 27 0.63V
V5 22 30 6.35V
R19 21 30 1.2E6
D4 21 15 DX
V4 29 22 0.63V
R18 20 29 24K
D3 15 20 DX
* Output inductor   
L3 22 28 1U                  
*
***************MODELS USED**************
*
.MODEL DX D(IS=1E-15)
.MODEL JX PJF(BETA=9.201E-5 VTO=-2.33 IS=10E-12 N=3)
*
.ENDS
*$
