//*****************************************************************************
//
// xmodem.h - Defines and Macros for the UART Xmodem simple file transfer
//            protocol.
//
// Copyright 2021 Texas Instruments Incorporated.
// Software License Agreement
// 
//   Redistribution and use in source and binary forms, with or without
//   modification, are permitted provided that the following conditions
//   are met: 
//
//   1. Redistributions of source code must retain the above copyright
//   notice, this list of conditions and the following disclaimer.
//   
//   2. Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the
//   documentation and/or other materials provided with the distribution.
// 
//   3. Neither the name of Texas Instruments Incorporated nor the names
//   of its contributors may be used to endorse or promote products
//   derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//*****************************************************************************

#ifndef XMODEM_H_
#define XMODEM_H_

//*****************************************************************************
//
// List of Xmodem protocol packet headers.
//
//*****************************************************************************
#define SOH  0x01u   // Start of Header
#define EOT  0x04u   // End of Transmission
#define ACK  0x06u   // Acknowledge
#define NACK 0x15u   // Negative Acknowledge
#define CAN  0x18u   // Cancel

//*****************************************************************************
//
// Prototypes for the APIs.
//
//*****************************************************************************
bool ReadXmodemKey(unsigned char *pucBuffer);
int ReadXmodemPacket(unsigned char ucBlock, unsigned char *pucBuffer);
void OutputEncryptedImage(void);
void VerifyEncryptedImage(void);
void XmodemLoadProgram(void);

#endif /* XMODEM_H_ */
