//*****************************************************************************
//
// shared_functions.h - Defines and Macros for the shared functions of the 
//                      shared key boot loader.
//
// Copyright 2021 Texas Instruments Incorporated.
// Software License Agreement
// 
//   Redistribution and use in source and binary forms, with or without
//   modification, are permitted provided that the following conditions
//   are met: 
//
//   1. Redistributions of source code must retain the above copyright
//   notice, this list of conditions and the following disclaimer.
//   
//   2. Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the
//   documentation and/or other materials provided with the distribution.
// 
//   3. Neither the name of Texas Instruments Incorporated nor the names
//   of its contributors may be used to endorse or promote products
//   derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//*****************************************************************************

#ifndef SHARED_FUNCTIONS_H_
#define SHARED_FUNCTIONS_H_

//*****************************************************************************
//
// List of DID1 register values for TM4C129x devices that contain a hardware
// AES encryption module.
//
//*****************************************************************************
#define TM4C129CNCPDT 0x10240000
#define TM4C129CNCZAD 0x10260000
#define TM4C129DNCPDT 0x10270000
#define TM4C129DNCZAD 0x10290000
#define TM4C129EKCPDT 0x10360000  // 512KB flash version
#define TM4C129ENCPDT 0x102D0000
#define TM4C129ENCZAD 0x102F0000
#define TM4C129LNCZAD 0x10300000
#define TM4C129XKCZAD 0x10370000  // 512KB flash version
#define TM4C129XNCZAD 0x10320000

//*****************************************************************************
//
// Boolean storage used to track if there are valid keys in the system or not.
//
//*****************************************************************************
extern bool bValidKeys;

//*****************************************************************************
//
// Buffer space reserved for receiving AES keys.  This is located in SRAM so 
// the keys must be cleared from SRAM before application execution.
//
//*****************************************************************************
extern uint32_t g_pui32Keys[32];

//*****************************************************************************
//
// Buffer space reserved for the Initialization Vector.  This is defined in a
// separate file as each firmware image should have it's unique IV.  By using
// this system, the shared key boot loader source does not have to be modified 
// to provide each unique application with a uniquely defined IV which is a
// best practice for AES Encryption.
//
//*****************************************************************************
extern const uint32_t g_pui32IV[4];

//*****************************************************************************
//
// Prototypes for the APIs.
//
//*****************************************************************************
bool CheckAESHardware(void);
void CalculateAESHash(uint32_t *pui32HashBuffer);
bool VerifyAESHash(void);
void EnableAESCBC(uint32_t ui32encryptDecrypt);
void EnableAESCBCMAC(uint32_t ui32encryptDecrypt);

#endif /* SHARED_FUNCTIONS_H_ */
