***********************************************************************
* Function: SetDBGIER()                                               *
* Description: Sets the DBGIER register (for realtime emulation).     *
* Device: TMS320F28xx                                                 *
* Author: David M. Alter, Texas Instruments Inc.                      *
* Function Prototype: void SetDBGIER(unsigned int);                   *
* Useage: SetDBGIER(value);                                           *
* Input Parameters:                                                   *
*        unsigned int value = value to put in the DBGIER register.    *
* Return Value: none                                                  *
* Notes: none                                                         *
* History:                                                            *
*   02/07/06 - original (D. Alter)                                    *
***********************************************************************
		.def _SetDBGIER
		.text
		
_SetDBGIER:
		MOV 	*SP++,AL
		POP 	DBGIER
		LRETR

; end of function SetDBGIER() *****************************************

       .end
; end of file SetDBGIER.asm *******************************************
