/*
 * display.h
 *
 * ============================================================================
 * Copyright (c) Texas Instruments Inc 2005
 *
 * Use of this software is controlled by the terms and conditions found in the
 * license agreement under which this software has been supplied or provided.
 * ============================================================================
 */

#ifndef _DISPLAY_H
#define _DISPLAY_H

#include <fifoutil.h>

/* Screen dimensions */
#define SCREEN_BPP               16

#define WIDTH_NTSC                 720
#define HEIGHT_NTSC                yScale(480)
#define LINE_WIDTH_NTSC            WIDTH_NTSC * SCREEN_BPP / 8
#define FRAME_SIZE_NTSC            LINE_WIDTH_NTSC * 480
#define FRAME_SIZE_MEM_NTSC        LINE_WIDTH_NTSC * HEIGHT_NTSC

#define WIDTH_PAL                  720
#define HEIGHT_PAL                 yScale(576)
#define LINE_WIDTH_PAL             WIDTH_PAL * SCREEN_BPP / 8
#define FRAME_SIZE_PAL             LINE_WIDTH_PAL * HEIGHT_PAL

#define WIDTH_VGA                  640
#define HEIGHT_VGA                 yScale(480)
#define LINE_WIDTH_VGA             WIDTH_VGA * SCREEN_BPP / 8
#define FRAME_SIZE_VGA             LINE_WIDTH_VGA * HEIGHT_VGA

#define WIDTH_720P                 1280
#define HEIGHT_720P                720
#define LINE_WIDTH_720P            WIDTH_720P * SCREEN_BPP / 8
#define FRAME_SIZE_720P            LINE_WIDTH_720P * HEIGHT_720P

#define WIDTH_1080I                1920
#define HEIGHT_1080I               1088
#define LINE_WIDTH_1080I           WIDTH_1080I * SCREEN_BPP / 8
#define FRAME_SIZE_1080I           LINE_WIDTH_1080I * HEIGHT_1080I

#define DISPLAY_FLUSH -1
#define DISPLAY_PRIME -2

#define DISPLAY_BUFFERS 3

typedef struct BufferElement {
    int   id;
    int   width;
    int   height;
    char *frameBuffer;
} BufferElement;


typedef struct VideoEnv {
    Rendezvous_Handle hRendezvous;
    VideoDecoder      videoDecoder;
    char             *videoFile;
    Resolution       resolution;
    int               loop;
  BufferElement    bufferElements[DISPLAY_BUFFERS];
} VideoEnv;


typedef struct DisplayEnv {
    Rendezvous_Handle hRendezvous;
    FifoUtil_Obj      outFifo;
    FifoUtil_Obj      inFifo;
    Resolution        resolution;
    pthread_mutex_t   prime;
    VideoEnv          *videoEnv;
} DisplayEnv;

extern void *displayThrFxn(void *arg);

#endif /* _DISPLAY_H */
