/*
 * loader.h
 *
 * ============================================================================
 * Copyright (c) Texas Instruments Inc 2005
 *
 * Use of this software is controlled by the terms and conditions found in the
 * license agreement under which this software has been supplied or provided.
 * ============================================================================
 */

#ifndef _LOADER_H
#define _LOADER_H

typedef struct LoaderState {
    int inputFd;            // INPUT - The file descriptor of the input file
    int loop;               // INPUT - true if clip is to start over
    char *readBuffer;       // INPUT - A large CMEM allocated buffer
    int readBufSize;        // INPUT - Total size of the readBuffer
    int readSize;           // INPUT - Size of the 'window'
    int doneMask;           // INPUT - VIDEO_DONE or SOUND_DONE
    int firstFrame;         // OUTPUT - True if first frame of a clip
    int endClip;            // OUTPUT - True if time to start clip over
    char *curPtr;           // INTERNAL - Points to current frame
    char *readPtr;          // INTERNAL - Points to the end of current 'window'
} LoaderState;

extern int loaderPrime(LoaderState *state, char **framePtr);
extern int loaderGetFrame(LoaderState *state, int frameSize, char **framePtr);

#endif /* _LOADER_H */
