/*
 * Decompiled with CFR 0.152.
 */
package fsigraphs.singleline.example;

import fsi.FSICore;
import fsi.FSIExecutionPoint;
import fsi.FSIRawDataCreator;
import fsi.FSIRawParser;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BubbleChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.BorderPane;

public class GraphFSIDelaySingleLineExamples_FXMLController
implements Initializable {
    @FXML
    private Tab Scenario1_TAB;
    @FXML
    private Tab Scenario2_TAB;
    @FXML
    private Tab Scenario3_TAB;
    @FXML
    private Tab Scenario4_TAB;
    @FXML
    private Tab Scenario5_TAB;
    @FXML
    private TabPane Scenario_TP;
    @FXML
    private BorderPane Scenario1_BP;
    @FXML
    private BorderPane Scenario2_BP;
    @FXML
    private BorderPane Scenario3_BP;
    @FXML
    private BorderPane Scenario4_BP;
    @FXML
    private BorderPane Scenario5_BP;
    @FXML
    private Label Scenrio1ExecutionPoints_L;
    @FXML
    private Label Scenrio2ExecutionPoints_L;
    @FXML
    private Label Scenrio3ExecutionPoints_L;
    @FXML
    private Label Scenrio4ExecutionPoints_L;
    @FXML
    private Label Scenrio5ExecutionPoints_L;
    @FXML
    private Tab Scenario6_TAB;
    @FXML
    private BorderPane Scenario6_BP;
    @FXML
    private Label Scenrio6ExecutionPoints_L;
    @FXML
    private Tab Scenario7_TAB;
    @FXML
    private BorderPane Scenario7_BP;
    @FXML
    private Label Scenrio7ExecutionPoints_L;
    @FXML
    private Tab Scenario8_TAB;
    @FXML
    private BorderPane Scenario8_BP;
    @FXML
    private Label Scenrio8ExecutionPoints_L;

    public void initialize(URL url, ResourceBundle rb) {
        FSIRawDataCreator.CreateScenarioFile("Scenario1.dat", 0, 18);
        FSIRawDataCreator.CreateScenarioFile("Scenario2.dat", 16, 18);
        FSIRawDataCreator.CreateScenarioFile("Scenario3.dat", 25, 18);
        FSIRawDataCreator.CreateScenarioFile("Scenario4.dat", -16, 18);
        FSIRawDataCreator.CreateScenarioFile("Scenario5.dat", -25, 18);
        FSIRawDataCreator.CreateScenarioFile("Scenario6.dat", 16, 64);
        FSIRawDataCreator.CreateScenarioFile("Scenario7.dat", -16, 64);
        FSIRawDataCreator.CreateScenarioFile("Scenario8.dat", 0, 64);
        BubbleChart scenario1Chart = this.CreateChart("Scenario 1", FSIRawDataCreator.OutFileDirPath + "\\Scenario1.dat", this.Scenario1_BP, this.Scenrio1ExecutionPoints_L);
        BubbleChart scenario2Chart = this.CreateChart("Scenario 2", FSIRawDataCreator.OutFileDirPath + "\\Scenario2.dat", this.Scenario2_BP, this.Scenrio2ExecutionPoints_L);
        BubbleChart scenario3Chart = this.CreateChart("Scenario 3", FSIRawDataCreator.OutFileDirPath + "\\Scenario3.dat", this.Scenario3_BP, this.Scenrio3ExecutionPoints_L);
        BubbleChart scenario4Chart = this.CreateChart("Scenario 4", FSIRawDataCreator.OutFileDirPath + "\\Scenario4.dat", this.Scenario4_BP, this.Scenrio4ExecutionPoints_L);
        BubbleChart scenario5Chart = this.CreateChart("Scenario 5", FSIRawDataCreator.OutFileDirPath + "\\Scenario5.dat", this.Scenario5_BP, this.Scenrio5ExecutionPoints_L);
        BubbleChart scenario6Chart = this.CreateChart("Scenario 6", FSIRawDataCreator.OutFileDirPath + "\\Scenario6.dat", this.Scenario6_BP, this.Scenrio6ExecutionPoints_L);
        BubbleChart scenario7Chart = this.CreateChart("Scenario 7", FSIRawDataCreator.OutFileDirPath + "\\Scenario7.dat", this.Scenario7_BP, this.Scenrio7ExecutionPoints_L);
        BubbleChart scenario8Chart = this.CreateChart("Scenario 8", FSIRawDataCreator.OutFileDirPath + "\\Scenario8.dat", this.Scenario8_BP, this.Scenrio8ExecutionPoints_L);
    }

    public BubbleChart CreateChart(String name, String filePath, BorderPane borderPane, Label label) {
        boolean[][] data = FSIRawParser.GenearateSingleArrayRX0vsCLK(filePath);
        NumberAxis xAxis = new NumberAxis(-1.0, 32.0, 2.0);
        NumberAxis yAxis = new NumberAxis(-1.0, 32.0, 2.0);
        xAxis.setLabel("RX0 Delay");
        yAxis.setLabel("CLK Delay");
        BubbleChart blc = new BubbleChart((Axis)xAxis, (Axis)yAxis);
        blc.setTitle("CLK vs RX0 " + name);
        XYChart.Series successSeries = new XYChart.Series();
        successSeries.setName("Success");
        XYChart.Series failSeries = new XYChart.Series();
        failSeries.setName("Failure");
        for (int clk = 0; clk < 32; ++clk) {
            for (int rx0 = 0; rx0 < 32; ++rx0) {
                if (data[clk][rx0]) {
                    successSeries.getData().add((Object)new XYChart.Data((Object)rx0, (Object)clk, (Object)0.4));
                    continue;
                }
                failSeries.getData().add((Object)new XYChart.Data((Object)rx0, (Object)clk, (Object)0.1));
            }
        }
        blc.getData().addAll((Object[])new XYChart.Series[]{successSeries});
        blc.getData().addAll((Object[])new XYChart.Series[]{failSeries});
        blc.prefHeightProperty().bind((ObservableValue)borderPane.heightProperty().subtract(20));
        blc.maxHeightProperty().bind((ObservableValue)borderPane.heightProperty().subtract(20));
        blc.minHeightProperty().bind((ObservableValue)borderPane.heightProperty().subtract(20));
        blc.prefWidthProperty().bind((ObservableValue)borderPane.heightProperty().subtract(20));
        blc.maxWidthProperty().bind((ObservableValue)borderPane.heightProperty().subtract(20));
        blc.minWidthProperty().bind((ObservableValue)borderPane.heightProperty().subtract(20));
        FSIExecutionPoint executionPoint = FSICore.CalculateSingleLineExecutionPoint(data);
        this.AddExecutionPointToChart(blc, executionPoint, label);
        borderPane.setCenter((Node)blc);
        return blc;
    }

    public void AddExecutionPointToChart(BubbleChart chart, FSIExecutionPoint point, Label label) {
        if (point != null) {
            String text = "Execution Point: (" + String.valueOf(point.RX0Delay) + ", " + String.valueOf(point.CLKDelay) + ")";
            XYChart.Series execPointSeries = new XYChart.Series();
            execPointSeries.setName("Execution Point");
            execPointSeries.getData().add((Object)new XYChart.Data((Object)point.RX0Delay, (Object)point.CLKDelay, (Object)0.5));
            int y = point.CLKDelay;
            text = text + " Other Points: ";
            for (int x = point.RX0Delay; x < 32; ++x) {
                if (y < 32) {
                    execPointSeries.getData().add((Object)new XYChart.Data((Object)x, (Object)y, (Object)0.2));
                    text = text + "(" + String.valueOf(x) + ", " + String.valueOf(y) + ") ";
                }
                ++y;
            }
            label.setText(text);
            chart.getData().add((Object)execPointSeries);
        }
    }
}

