/*
 * Decompiled with CFR 0.152.
 */
package fsiskewcompensationutility;

import fileutilities.FileUtilities;
import fsi.FSICore;
import fsi.FSIExecutionPoint;
import fsi.FSIRawParser;
import fsigraphs.delaymeasurement.GraphFSIDelayMeasurement_FXMLController;
import fsigraphs.dualline.trellis.GraphFSIDelayTrellis_FXMLController;
import fsigraphs.singleline.GraphFSIDelaySingleLine_FXMLController;
import fsigraphs.singleline.example.GraphFSIDelaySingleLineExamples_FXMLController;
import fsiskewcompensationutility.FSISkewCompensationUtility;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.stage.Stage;

public class MainMenu_FXMLController
implements Initializable {
    @FXML
    private Button ViewExampleData_B;
    @FXML
    private Button SingleLineRX0vsCLK_B;
    @FXML
    private Button DualLineCLKTrellis_B;
    @FXML
    private Button DelayTapMeasurement_B;

    public void initialize(URL url, ResourceBundle rb) {
    }

    @FXML
    private void ViewExampleData_B_Click(ActionEvent event) {
        try {
            Stage stage = new Stage();
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fsigraphs/singleline/example/GraphFSIDelaySingleLineExamples_FXML.fxml"));
            Parent root = (Parent)loader.load();
            GraphFSIDelaySingleLineExamples_FXMLController controller = (GraphFSIDelaySingleLineExamples_FXMLController)loader.getController();
            Scene scene = new Scene(root);
            stage.getIcons().add((Object)new Image(this.getClass().getResourceAsStream("/images/TI_logo_small.png")));
            stage.setScene(scene);
            stage.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @FXML
    private void SingleLineRX0vsCLK_B_Click(ActionEvent event) {
        boolean[][] rx0VsclkArray = null;
        FSIExecutionPoint point = null;
        if ("".equals(FSISkewCompensationUtility.singleFilePath)) {
            FileUtilities.ShowDialog("Select an input!", "Please select a the file containing the saved memory for the single data line communication!", "The single data line communication file must be selected next!");
            File file = FileUtilities.ChooseFile("Select the single line data file", new String[]{"*"});
            if (file != null) {
                FSISkewCompensationUtility.singleFilePath = file.getAbsolutePath();
            }
        }
        if (!"".equals(FSISkewCompensationUtility.singleFilePath)) {
            rx0VsclkArray = FSIRawParser.GenearateSingleArrayRX0vsCLK(FSISkewCompensationUtility.singleFilePath);
            point = FSICore.CalculateSingleLineExecutionPoint(rx0VsclkArray);
        }
        try {
            Stage singleStage = new Stage();
            FXMLLoader loaderSignle = new FXMLLoader(this.getClass().getResource("/fsigraphs/singleline/GraphFSIDelaySingleLine_FXML.fxml"));
            Parent rootSingle = (Parent)loaderSignle.load();
            GraphFSIDelaySingleLine_FXMLController controllerSingle = (GraphFSIDelaySingleLine_FXMLController)loaderSignle.getController();
            controllerSingle.SetData(rx0VsclkArray);
            controllerSingle.SetStage(singleStage);
            Scene sceneSingle = new Scene(rootSingle);
            String pointValue = "";
            if (point != null) {
                pointValue = point.toString();
            }
            singleStage.setTitle(FSISkewCompensationUtility.singleFilePath + " " + pointValue);
            singleStage.setScene(sceneSingle);
            singleStage.getIcons().add((Object)new Image(this.getClass().getResourceAsStream("/images/TI_logo_small.png")));
            singleStage.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @FXML
    private void DualLineCLKTrellis_B_Click(ActionEvent event) {
        try {
            File file;
            Stage dualStage = new Stage();
            dualStage.setTitle("RX0/CLK Set vs RX1");
            FSIExecutionPoint execPoint = null;
            boolean[][][] rx0Vsrx1Array = null;
            if ("".equals(FSISkewCompensationUtility.singleFilePath)) {
                FileUtilities.ShowDialog("Select an input!", "Please select a the file containing the saved memory for the single data line communication!", "The single data line communication file must be selected next!");
                file = FileUtilities.ChooseFile("Select the single line data file", new String[]{"*"});
                if (file != null) {
                    FSISkewCompensationUtility.singleFilePath = file.getAbsolutePath();
                }
            }
            if ("".equals(FSISkewCompensationUtility.dualFilePath)) {
                FileUtilities.ShowDialog("Select an input!", "Please select a the file containing the saved memory for the dual data line communication!", "The dual data line communication file must be selected next!");
                file = FileUtilities.ChooseFile("Select the dual line data file", new String[]{"*"});
                if (file != null) {
                    FSISkewCompensationUtility.dualFilePath = file.getAbsolutePath();
                }
            }
            if (!"".equals(FSISkewCompensationUtility.singleFilePath)) {
                boolean[][] rx0VsclkArray = FSIRawParser.GenearateSingleArrayRX0vsCLK(FSISkewCompensationUtility.singleFilePath);
                execPoint = FSICore.CalculateSingleLineExecutionPoint(rx0VsclkArray);
            }
            if (!"".equals(FSISkewCompensationUtility.dualFilePath)) {
                rx0Vsrx1Array = FSIRawParser.GenearateDualArrayRX0vsRX1vsCLK(FSISkewCompensationUtility.dualFilePath);
            }
            FXMLLoader loaderDual = new FXMLLoader(this.getClass().getResource("/fsigraphs/dualline/trellis/GraphFSIDelayTrellis_FXML.fxml"));
            Parent rootDual = (Parent)loaderDual.load();
            GraphFSIDelayTrellis_FXMLController controllerDual = (GraphFSIDelayTrellis_FXMLController)loaderDual.getController();
            controllerDual.SetData(rx0Vsrx1Array, execPoint);
            controllerDual.SetStage(dualStage);
            Scene sceneDual = new Scene(rootDual);
            dualStage.getIcons().add((Object)new Image(this.getClass().getResourceAsStream("/images/TI_logo_small.png")));
            dualStage.setScene(sceneDual);
            dualStage.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @FXML
    private void DelayTapMeasurement_B_Click(ActionEvent event) {
        try {
            if ("".equals(FSISkewCompensationUtility.delayMeasureFilePath)) {
                FileUtilities.ShowDialog("Select an input!", "Please select a the file containing the saved memory for the delay measurement!", "The delay measurement file must be selected next!");
                File file = FileUtilities.ChooseFile("Select the delay measurement file", new String[]{"*"});
                if (file != null) {
                    FSISkewCompensationUtility.delayMeasureFilePath = file.getAbsolutePath();
                }
            }
            Stage stage = new Stage();
            stage.setTitle("Delay Measurement");
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fsigraphs/delaymeasurement/GraphFSIDelayMeasurement_FXML.fxml"));
            Parent root = (Parent)loader.load();
            GraphFSIDelayMeasurement_FXMLController controller = (GraphFSIDelayMeasurement_FXMLController)loader.getController();
            Scene scene = new Scene(root);
            stage.getIcons().add((Object)new Image(this.getClass().getResourceAsStream("/images/TI_logo_small.png")));
            stage.setScene(scene);
            stage.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

