/*
 * Decompiled with CFR 0.152.
 */
package fsigraphs.delaymeasurement;

import fileutilities.FileUtilities;
import fsi.FSIRawParser;
import fsiskewcompensationutility.FSISkewCompensationUtility;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;

public class GraphFSIDelayMeasurement_FXMLController
implements Initializable {
    @FXML
    private LineChart<Number, Number> DelayLineChart_LC;
    @FXML
    private TableView<DelayTableItem> DelayTable_TV;
    @FXML
    private TableColumn DelayTap_TC;
    @FXML
    private TableColumn DelayTime_TC;

    public void initialize(URL url, ResourceBundle rb) {
        File file;
        if ("".equals(FSISkewCompensationUtility.delayMeasureFilePath) && (file = FileUtilities.ChooseFile("Select the delay measurement file", new String[]{"*"})) != null) {
            FSISkewCompensationUtility.delayMeasureFilePath = file.getAbsolutePath();
        }
        if (!"".equals(FSISkewCompensationUtility.delayMeasureFilePath)) {
            double[] delays = FSIRawParser.GenearateDelayMeasurementArray(FSISkewCompensationUtility.delayMeasureFilePath);
            this.SetGraph(delays);
            this.SetTable(delays);
        }
    }

    public void SetGraph(double[] delay) {
        XYChart.Series series = new XYChart.Series();
        series.setName("Delay");
        for (int i = 0; i < 32; ++i) {
            series.getData().add((Object)new XYChart.Data((Object)i, (Object)delay[i]));
        }
        this.DelayLineChart_LC.getData().add((Object)series);
    }

    public void SetTable(double[] delay) {
        ObservableList data = FXCollections.observableArrayList();
        for (int i = 0; i < 32; ++i) {
            data.add((Object)new DelayTableItem(i, delay[i]));
        }
        this.DelayTap_TC.setCellValueFactory((Callback)new PropertyValueFactory("delayTap"));
        this.DelayTime_TC.setCellValueFactory((Callback)new PropertyValueFactory("delayTime"));
        this.DelayTable_TV.setItems(data);
    }

    public class DelayTableItem {
        private final SimpleIntegerProperty delayTap;
        private final SimpleDoubleProperty delayTime;

        private DelayTableItem(int tap, double time) {
            this.delayTap = new SimpleIntegerProperty(tap);
            this.delayTime = new SimpleDoubleProperty(time);
        }

        public int getDelayTap() {
            return this.delayTap.get();
        }

        public void setDelayTap(int tap) {
            this.delayTap.set(tap);
        }

        public double getDelayTime() {
            return this.delayTime.get();
        }

        public void setDelayTime(double time) {
            this.delayTime.set(time);
        }
    }
}

