/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package fsi;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;

/**
 *
 * @author a0225962
 */
public class FSIRawDataCreator {
    static public String OutFileDirPath = Paths.get("").toAbsolutePath().toString();
    
    
    public static void CreateScenarioFile(String filename, int shift, int passWidth)
    {
        FileWriter outFileWriter = null;
        try {
            File outFile = new File(OutFileDirPath + "\\" + filename);
            outFileWriter = new FileWriter(outFile);
            outFileWriter.write("Dummy Header\n");
            
            for (int clk = 0; clk < 32; clk++)
            {
                long number = 0;
                int rx0Left = (clk + shift) - (passWidth / 2);
                int rx0Right = (clk + shift) + (passWidth / 2);
                for (int rx0 = 0; rx0 < 32; rx0++)
                {
                    if (rx0 > rx0Left && rx0 < rx0Right)
                    {
                        number |= (1 << rx0);
                    }
                }
                String line = Long.toHexString(number);
                if (line.length() > 8)
                {
                    line = line.substring(line.length() - 8);
                }
                else
                {
                    String zeroPadding  = 
                            "00000000".substring(0, 8 - line.length());
                    line = zeroPadding + line;
                }
                line = line.toUpperCase();
                outFileWriter.write(line + "\n");
            }
            
        }
        catch (Exception ex) {
            System.out.println("An error occured: " + ex.getMessage());
        } 
        finally {
            try {
                outFileWriter.close();
                System.out.println("Done Writing Scenario Data");
            } catch (IOException ex) {
                
            }
        }
        
    }
    
}
