/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package fsigraphs.singleline;

import fsi.FSICore;
import fsi.FSIExecutionPoint;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.chart.BubbleChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

/**
 * FXML Controller class
 *
 * @author a0225962
 */
public class GraphFSIDelaySingleLine_FXMLController implements Initializable {
  
    @FXML
    private ScrollPane Graph_SP;
    @FXML
    private VBox Graph_VB;
    @FXML
    private Label Status_L;

    /**
     * Initializes the controller class.
     */
    @Override
    public void initialize(URL url, ResourceBundle rb) {
        // TODO
    }    
    
    
    public void SetData(boolean[][] data)
    {
        if(data != null)
        {
            FSIExecutionPoint executionPoint = 
                    FSICore.CalculateSingleLineExecutionPoint(data);        
            if (executionPoint != null)
            {
                Status_L.setText("Execution Point is set to: " 
                        + executionPoint.toString());

            }
            else
            {
                Status_L.setText("Execution Point not found!");
            }
            BubbleChart chart = CreateChart(data);
            AddExecutionPointToChart(chart, executionPoint, Status_L);
        }
    }
    private Stage ParentStage;
    public void SetStage(Stage stage) {
         ParentStage = stage;
    }
    
    public BubbleChart CreateChart(boolean [][] data)
    {
        final NumberAxis xAxis = new NumberAxis(-1, 32, 2);
        final NumberAxis yAxis = new NumberAxis(-1, 32, 2);
        xAxis.setLabel("RX0 Delay");
        yAxis.setLabel("CLK Delay");
        final BubbleChart<Number,Number> blc = new
                BubbleChart<>(xAxis,yAxis);
        blc.setTitle("CLK vs RX0");
        XYChart.Series successSeries = new XYChart.Series();
        successSeries.setName("Success");

        XYChart.Series failSeries = new XYChart.Series();
        failSeries.setName("Failure");
        for (int clk = 0; clk < 32; clk++)
        {
            for (int rx0 = 0; rx0 < 32; rx0++)
            {
                if (data[clk][rx0])
                {
                    successSeries.getData().add(
                            new XYChart.Data(rx0, clk, 0.4));
                }
                else
                {
                    failSeries.getData().add(
                            new XYChart.Data(rx0, clk, 0.1));
                }
            }
        }
        blc.getData().addAll(successSeries); 
        blc.getData().addAll(failSeries); 
        blc.prefHeightProperty().bind(Graph_SP.heightProperty().subtract(10));
        blc.maxHeightProperty().bind(Graph_SP.heightProperty().subtract(10));
        blc.minHeightProperty().bind(Graph_SP.heightProperty().subtract(10));
        blc.prefWidthProperty().bind(Graph_SP.heightProperty().subtract(10));
        blc.maxWidthProperty().bind(Graph_SP.heightProperty().subtract(10));
        blc.minWidthProperty().bind(Graph_SP.heightProperty().subtract(10));
        
        Graph_VB.getChildren().add(blc);

        return blc;
    }
    
    public void AddExecutionPointToChart(BubbleChart chart, FSIExecutionPoint point, Label label)
    {
        if (point != null)
        {
            String text = "Execution Point: " 
                    + "(" + String.valueOf(point.RX0Delay) + ", " 
                    + String.valueOf(point.CLKDelay) + ")";
            
            XYChart.Series execPointSeries = new XYChart.Series();
            execPointSeries.setName("Execution Point");
            execPointSeries.getData().add(
                    new XYChart.Data(point.RX0Delay, point.CLKDelay, 0.5));
            
            int y = point.CLKDelay;
            
            text += " Other Points: ";
            for (int x = point.RX0Delay; x < 32; x++)
            {
                if (y < 32)
                {
                    execPointSeries.getData().add(
                        new XYChart.Data(x, y, 0.2));
                    text += "(" + String.valueOf(x) + ", " + String.valueOf(y) + ") ";
                }
                y++;
            }
            
            label.setText(text);
            chart.getData().add(execPointSeries);
            
        }
    }
    
}
